/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.websockets;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.vysper.xmpp.extension.websockets.XmppWebSocketServlet;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEndpoint
implements Endpoint {
    protected static final Logger logger = LoggerFactory.getLogger(WebSocketEndpoint.class);
    protected ServerRuntimeContext serverRuntimeContext;
    protected int port = 8080;
    protected Server server;
    protected boolean isSSLEnabled;
    protected String sslKeystorePath;
    protected String sslKeystorePassword;
    protected String contextPath = "/";

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSSLCertificateKeystore(String keystorePath, String password) {
        this.sslKeystorePath = keystorePath;
        this.sslKeystorePassword = password;
    }

    public void setSSLEnabled(boolean value) {
        this.isSSLEnabled = value;
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        this.contextPath = contextPath;
    }

    protected Server createJettyServer() {
        SelectChannelConnector connector;
        Server server = new Server();
        if (this.isSSLEnabled) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            sslConnector.setKeystore(this.sslKeystorePath);
            sslConnector.setPassword(this.sslKeystorePassword);
            sslConnector.setKeyPassword(this.sslKeystorePassword);
            connector = sslConnector;
        } else {
            connector = new SelectChannelConnector();
        }
        connector.setPort(this.port);
        server.setConnectors(new Connector[]{connector});
        return server;
    }

    protected Handler createHandler() {
        ServletContextHandler servletContext = new ServletContextHandler(1);
        servletContext.setContextPath(this.contextPath);
        XmppWebSocketServlet wsServlet = new XmppWebSocketServlet(this.serverRuntimeContext);
        servletContext.addServlet(new ServletHolder((Servlet)wsServlet), "/ws");
        return servletContext;
    }

    public void start() throws IOException {
        this.server = this.createJettyServer();
        Handler wsHandler = this.createHandler();
        Handler existingHandler = this.server.getHandler();
        if (existingHandler != null && existingHandler instanceof HandlerCollection) {
            ((HandlerCollection)existingHandler).addHandler(wsHandler);
        } else {
            this.server.setHandler(wsHandler);
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.warn("Could not stop the Jetty server", (Throwable)e);
        }
    }
}

