/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.management.sampled.SampledCacheManagerMBean;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCacheManager
extends BaseEmitterBean
implements SampledCacheManagerMBean {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final CacheManager cacheManager;
    private String mbeanRegisteredName;
    private volatile boolean mbeanRegisteredNameSet;

    public SampledCacheManager(CacheManager cacheManager) throws NotCompliantMBeanException {
        super(SampledCacheManagerMBean.class);
        this.cacheManager = cacheManager;
        cacheManager.setCacheManagerEventListener(new EventListener());
    }

    void setMBeanRegisteredName(String name) {
        if (this.mbeanRegisteredNameSet) {
            throw new IllegalStateException("Name used for registering this mbean is already set");
        }
        this.mbeanRegisteredNameSet = true;
        this.mbeanRegisteredName = name;
    }

    @Override
    public void clearAll() {
        this.cacheManager.clearAll();
        this.sendNotification("CachesCleared");
    }

    @Override
    public String[] getCacheNames() throws IllegalStateException {
        return this.cacheManager.getCacheNames();
    }

    @Override
    public String getStatus() {
        return this.cacheManager.getStatus().toString();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Map<String, long[]> getCacheMetrics() {
        String[] caches;
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result.put(cacheName, new long[]{stats.getCacheHitMostRecentSample(), stats.getCacheMissMostRecentSample(), stats.getCacheElementPutMostRecentSample()});
        }
        return result;
    }

    @Override
    public long getCacheHitRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheHitMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheMissRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheMissMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCachePutRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementPutMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheUpdateRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementUpdatedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheEvictionRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementEvictedMostRecentSample();
        }
        return result;
    }

    @Override
    public long getCacheExpirationRate() {
        String[] caches;
        long result = 0L;
        for (String cacheName : caches = this.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            SampledCacheStatistics stats = cache.getSampledCacheStatistics();
            result += stats.getCacheElementExpiredMostRecentSample();
        }
        return result;
    }

    @Override
    public String getName() {
        return this.cacheManager.getName();
    }

    @Override
    public String getMBeanRegisteredName() {
        return this.mbeanRegisteredName;
    }

    @Override
    public void clearStatistics() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.clearStatistics();
        }
        this.sendNotification("StatisticsReset");
    }

    @Override
    public void enableStatistics() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.setSampledStatisticsEnabled(true);
        }
        this.sendNotification("StatisticsEnabled", Boolean.TRUE);
    }

    @Override
    public void disableStatistics() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.setStatisticsEnabled(false);
        }
        this.sendNotification("StatisticsEnabled", Boolean.FALSE);
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            this.enableStatistics();
        } else {
            this.disableStatistics();
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || cache.isSampledStatisticsEnabled()) continue;
            return false;
        }
        return true;
    }

    private boolean determineStatisticsEnabled() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || cache.isStatisticsEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String generateActiveConfigDeclaration() {
        return this.cacheManager.getActiveConfigurationText();
    }

    @Override
    public String generateActiveConfigDeclaration(String cacheName) {
        return this.cacheManager.getActiveConfigurationText(cacheName);
    }

    @Override
    public boolean isEnabled() throws CacheException {
        String[] cacheNames;
        for (String cacheName : cacheNames = this.cacheManager.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null || !cache.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        String[] cacheNames;
        for (String cacheName : cacheNames = this.cacheManager.getCacheNames()) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            if (cache == null) continue;
            cache.setDisabled(!enabled);
        }
        this.sendNotification("CachesEnabled", enabled);
    }

    private boolean determineEnabled() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || !cache.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    static {
        String[] notifTypes = new String[]{"CachesEnabled", "CachesCleared", "StatisticsEnabled", "StatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache SampledCacheManager Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Ehcache SampledCacheManager Event")};
    }

    private class EventListener
    implements CacheManagerEventListener {
        private Status status = Status.STATUS_UNINITIALISED;

        private EventListener() {
        }

        public void dispose() throws CacheException {
            this.status = Status.STATUS_SHUTDOWN;
        }

        public Status getStatus() {
            return this.status;
        }

        public void init() throws CacheException {
            this.status = Status.STATUS_ALIVE;
        }

        public void notifyCacheAdded(String cacheName) {
        }

        public void notifyCacheRemoved(String cacheName) {
        }
    }
}

