/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.jcr.RepositoryException;
import org.xml.sax.InputSource;

public class ClonedInputSource
extends InputSource {
    private final char[] characterArray;
    private final byte[] byteArray;

    public ClonedInputSource(InputSource input) throws RepositoryException {
        if (input == null) {
            throw new IllegalArgumentException("Argument 'input' may not be null.");
        }
        this.characterArray = ClonedInputSource.read(input.getCharacterStream());
        this.byteArray = ClonedInputSource.read(input.getByteStream());
        this.setEncoding(input.getEncoding());
        this.setPublicId(input.getPublicId());
        this.setSystemId(input.getSystemId());
        if (this.characterArray != null) {
            this.setCharacterStream(new CharArrayReader(this.characterArray));
        }
        if (this.byteArray != null) {
            this.setByteStream(new ByteArrayInputStream(this.byteArray));
        }
    }

    private ClonedInputSource(char[] characterArray, byte[] byteArray) {
        this.characterArray = characterArray;
        this.byteArray = byteArray;
    }

    public char[] getCharacterArray() {
        return this.characterArray;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }

    public ClonedInputSource cloneInputSource() {
        ClonedInputSource res = new ClonedInputSource(this.characterArray, this.byteArray);
        res.setEncoding(this.getEncoding());
        res.setPublicId(this.getPublicId());
        res.setSystemId(this.getSystemId());
        if (this.byteArray != null) {
            res.setByteStream(new ByteArrayInputStream(this.byteArray));
        }
        if (this.characterArray != null) {
            res.setCharacterStream(new CharArrayReader(this.characterArray));
        }
        return res;
    }

    private static byte[] read(InputStream stream) throws RepositoryException {
        if (stream != null) {
            try {
                int numRead;
                int bufferSize = Math.min(stream.available(), 4096);
                ByteArrayOutputStream s = new ByteArrayOutputStream(bufferSize);
                byte[] buffer = new byte[bufferSize];
                do {
                    if ((numRead = stream.read(buffer)) <= 0) continue;
                    s.write(buffer, 0, numRead);
                } while (numRead == bufferSize);
                byte[] byArray = s.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    private static char[] read(Reader reader) throws RepositoryException {
        if (reader != null) {
            try {
                int numRead;
                int bufferSize = 4096;
                CharArrayWriter w = new CharArrayWriter(4096);
                char[] buffer = new char[4096];
                do {
                    if ((numRead = reader.read(buffer)) <= 0) continue;
                    w.write(buffer, 0, numRead);
                } while (numRead == 4096);
                char[] cArray = w.toCharArray();
                return cArray;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }
}

