/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryHits;
import org.apache.jackrabbit.core.query.lucene.NodeTraversingQueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;

public class ChildNodesQueryHits
extends AbstractQueryHits {
    private final QueryHits parents;
    private final SessionImpl session;
    private QueryHits childHits;

    public ChildNodesQueryHits(QueryHits parents, SessionImpl session) throws IOException {
        this.parents = parents;
        this.session = session;
        this.fetchNextChildHits();
    }

    public void close() throws IOException {
        if (this.childHits != null) {
            this.childHits.close();
        }
        this.parents.close();
    }

    public ScoreNode nextScoreNode() throws IOException {
        while (this.childHits != null) {
            ScoreNode sn = this.childHits.nextScoreNode();
            if (sn != null) {
                return sn;
            }
            this.fetchNextChildHits();
        }
        return null;
    }

    private void fetchNextChildHits() throws IOException {
        ScoreNode nextParent;
        if (this.childHits != null) {
            this.childHits.close();
        }
        if ((nextParent = this.parents.nextScoreNode()) != null) {
            try {
                NodeImpl parent = this.session.getNodeById(nextParent.getNodeId());
                this.childHits = new NodeTraversingQueryHits((Node)parent, false, 1);
            }
            catch (RepositoryException e) {
                throw Util.createIOException(e);
            }
        } else {
            this.childHits = null;
        }
    }
}

