/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner;

import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubPrivilege;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.owner.AbstractPubSubOwnerHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class PubSubOwnerDeleteNodeHandler
extends AbstractPubSubOwnerHandler {
    public PubSubOwnerDeleteNodeHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    protected String getWorkerElement() {
        return "delete";
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubOwnerDeleteNodeHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        String nodeName = this.extractNodeName(stanza);
        LeafNode node = root.find(nodeName);
        if (node == null) {
            return this.errorStanzaGenerator.generateNoNodeErrorStanza(sender, serverJID, stanza);
        }
        if (!node.isAuthorized(sender, PubSubPrivilege.DELETE)) {
            return this.errorStanzaGenerator.generateInsufficientPrivilegesErrorStanza(sender, serverJID, stanza);
        }
        this.sendDeleteNotifications(serverRuntimeContext, sender, nodeName, node);
        root.deleteNode(nodeName);
        return new IQStanza((Stanza)sb.build());
    }

    private void sendDeleteNotifications(ServerRuntimeContext serverRuntimeContext, Entity sender, String nodeName, LeafNode node) {
        StanzaRelay relay = serverRuntimeContext.getStanzaRelay();
        String strID = this.idGenerator.create();
        XMLElement delete = this.createDeleteElement(nodeName);
        node.publish(sender, relay, strID, delete);
    }

    private XMLElement createDeleteElement(String nodeName) {
        return new XMLElement(null, "delete", null, new Attribute[]{new Attribute("node", nodeName)}, (XMLFragment[])null);
    }
}

