/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.sshd.common.config.keys.KeyTypeNamesSupport;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.io.IoUtils;

public interface KeyEntryResolver
extends KeyTypeNamesSupport {
    public static final int MAX_BIGINT_OCTETS_COUNT = Short.MAX_VALUE;

    default public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(keySize);
        return gen.generateKeyPair();
    }

    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException;

    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException;

    public static int encodeString(OutputStream s, String v) throws IOException {
        return KeyEntryResolver.encodeString(s, v, StandardCharsets.UTF_8);
    }

    public static int encodeString(OutputStream s, String v, String charset) throws IOException {
        return KeyEntryResolver.encodeString(s, v, Charset.forName(charset));
    }

    public static int encodeString(OutputStream s, String v, Charset cs) throws IOException {
        return KeyEntryResolver.writeRLEBytes(s, v.getBytes(cs));
    }

    public static int encodeBigInt(OutputStream s, BigInteger v) throws IOException {
        return KeyEntryResolver.writeRLEBytes(s, v.toByteArray());
    }

    public static int writeRLEBytes(OutputStream s, byte ... bytes) throws IOException {
        return KeyEntryResolver.writeRLEBytes(s, bytes, 0, bytes.length);
    }

    public static int writeRLEBytes(OutputStream s, byte[] bytes, int off, int len) throws IOException {
        byte[] lenBytes = KeyEntryResolver.encodeInt(s, len);
        s.write(bytes, off, len);
        return lenBytes.length + len;
    }

    public static byte[] encodeInt(OutputStream s, int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(v >> 24 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
        s.write(bytes);
        return bytes;
    }

    public static String decodeString(InputStream s, int maxChars) throws IOException {
        return KeyEntryResolver.decodeString(s, StandardCharsets.UTF_8, maxChars);
    }

    public static String decodeString(InputStream s, String charset, int maxChars) throws IOException {
        return KeyEntryResolver.decodeString(s, Charset.forName(charset), maxChars);
    }

    public static String decodeString(InputStream s, Charset cs, int maxChars) throws IOException {
        byte[] bytes = KeyEntryResolver.readRLEBytes(s, maxChars * 4);
        return new String(bytes, cs);
    }

    public static BigInteger decodeBigInt(InputStream s) throws IOException {
        return new BigInteger(KeyEntryResolver.readRLEBytes(s, Short.MAX_VALUE));
    }

    public static byte[] readRLEBytes(InputStream s, int maxAllowed) throws IOException {
        int len = KeyEntryResolver.decodeInt(s);
        if (len > maxAllowed) {
            throw new StreamCorruptedException("Requested block length (" + len + ") exceeds max. allowed (" + maxAllowed + ")");
        }
        if (len < 0) {
            throw new StreamCorruptedException("Negative block length requested: " + len);
        }
        byte[] bytes = new byte[len];
        IoUtils.readFully(s, bytes);
        return bytes;
    }

    public static int decodeInt(InputStream s) throws IOException {
        byte[] bytes = new byte[]{0, 0, 0, 0};
        IoUtils.readFully(s, bytes);
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static Map.Entry<String, Integer> decodeString(byte[] buf, int maxChars) {
        return KeyEntryResolver.decodeString(buf, 0, NumberUtils.length(buf), maxChars);
    }

    public static Map.Entry<String, Integer> decodeString(byte[] buf, int offset, int available, int maxChars) {
        return KeyEntryResolver.decodeString(buf, offset, available, StandardCharsets.UTF_8, maxChars);
    }

    public static Map.Entry<String, Integer> decodeString(byte[] buf, Charset cs, int maxChars) {
        return KeyEntryResolver.decodeString(buf, 0, NumberUtils.length(buf), cs, maxChars);
    }

    public static Map.Entry<String, Integer> decodeString(byte[] buf, int offset, int available, Charset cs, int maxChars) {
        Map.Entry<byte[], Integer> result = KeyEntryResolver.readRLEBytes(buf, offset, available, maxChars * 4);
        byte[] bytes = result.getKey();
        Integer nextOffset = result.getValue();
        return new AbstractMap.SimpleImmutableEntry<String, Integer>(new String(bytes, cs), nextOffset);
    }

    public static Map.Entry<byte[], Integer> readRLEBytes(byte[] buf, int maxAllowed) {
        return KeyEntryResolver.readRLEBytes(buf, 0, NumberUtils.length(buf), maxAllowed);
    }

    public static Map.Entry<byte[], Integer> readRLEBytes(byte[] buf, int offset, int available, int maxAllowed) {
        int len = KeyEntryResolver.decodeInt(buf, offset, available);
        if (len > maxAllowed) {
            throw new IndexOutOfBoundsException("Requested block length (" + len + ") exceeds max. allowed (" + maxAllowed + ")");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Negative block length requested: " + len);
        }
        if (len > (available -= 4)) {
            throw new IndexOutOfBoundsException("Requested block length (" + len + ") exceeds remaing (" + available + ")");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(buf, offset += 4, bytes, 0, len);
        return new AbstractMap.SimpleImmutableEntry<byte[], Integer>(bytes, offset + len);
    }

    public static int decodeInt(byte[] buf) {
        return KeyEntryResolver.decodeInt(buf, 0, NumberUtils.length(buf));
    }

    public static int decodeInt(byte[] buf, int offset, int available) {
        if (available < 4) {
            throw new IndexOutOfBoundsException("Available data length (" + available + ") cannot accommodate integer encoding");
        }
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }
}

