/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import org.springframework.expression.Expression;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultFileNameGenerator
extends AbstractExpressionEvaluator
implements FileNameGenerator {
    private volatile Expression expression = EXPRESSION_PARSER.parseExpression("headers['file_name']");

    public void setExpression(String expression) {
        Assert.hasText((String)expression, (String)"expression must not be empty");
        this.expression = EXPRESSION_PARSER.parseExpression(expression);
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"'headerName' must not be null");
        this.expression = EXPRESSION_PARSER.parseExpression("headers['" + headerName + "']");
    }

    @Override
    public String generateFileName(Message<?> message) {
        Object filename = this.evaluateExpression(this.expression, message);
        if (filename instanceof String && StringUtils.hasText((String)((String)filename))) {
            return (String)filename;
        }
        if (message.getPayload() instanceof File) {
            return ((File)message.getPayload()).getName();
        }
        return message.getHeaders().getId() + ".msg";
    }
}

