/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent;

import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;

public final class SshAgentConstants {
    public static final byte SSH_AGENT_FAILURE = 5;
    public static final byte SSH_AGENT_SUCCESS = 6;
    public static final byte SSH_AGENT_RSA_IDENTITIES_ANSWER = 2;
    public static final byte SSH_AGENT_RSA_RESPONSE = 4;
    public static final byte SSH_AGENTC_REQUEST_RSA_IDENTITIES = 1;
    public static final byte SSH_AGENTC_RSA_CHALLENGE = 3;
    public static final byte SSH_AGENTC_ADD_RSA_IDENTITY = 7;
    public static final byte SSH_AGENTC_REMOVE_RSA_IDENTITY = 8;
    public static final byte SSH_AGENTC_REMOVE_ALL_RSA_IDENTITIES = 9;
    public static final byte SSH_AGENTC_ADD_RSA_ID_CONSTRAINED = 24;
    public static final byte SSH2_AGENTC_REQUEST_IDENTITIES = 11;
    public static final byte SSH2_AGENTC_SIGN_REQUEST = 13;
    public static final byte SSH2_AGENTC_ADD_IDENTITY = 17;
    public static final byte SSH2_AGENTC_REMOVE_IDENTITY = 18;
    public static final byte SSH2_AGENTC_REMOVE_ALL_IDENTITIES = 19;
    public static final byte SSH2_AGENTC_ADD_ID_CONSTRAINED = 25;
    public static final byte SSH_AGENTC_ADD_SMARTCARD_KEY = 20;
    public static final byte SSH_AGENTC_REMOVE_SMARTCARD_KEY = 21;
    public static final byte SSH_AGENTC_LOCK = 22;
    public static final byte SSH_AGENTC_UNLOCK = 23;
    public static final byte SSH_AGENTC_ADD_SMARTCARD_KEY_CONSTRAINED = 26;
    public static final byte SSH2_AGENT_FAILURE = 30;
    public static final byte SSH2_AGENT_IDENTITIES_ANSWER = 12;
    public static final byte SSH2_AGENT_SIGN_RESPONSE = 14;
    public static final byte SSH_AGENT_CONSTRAIN_LIFETIME = 1;
    public static final byte SSH_AGENT_CONSTRAIN_CONFIRM = 2;
    public static final int SSH_AGENT_LIST_KEYS = 204;
    public static final int SSH_AGENT_PRIVATE_KEY_OP = 205;
    public static final byte SSH_AGENT_KEY_LIST = 104;
    public static final byte SSH_AGENT_OPERATION_COMPLETE = 105;

    private SshAgentConstants() {
    }

    public static String getCommandMessageName(int cmd) {
        String name = (String)LazyMessagesMapHolder.MESSAGES_MAP.get(cmd);
        if (GenericUtils.isEmpty(name)) {
            return Integer.toString(cmd);
        }
        return name;
    }

    private static class LazyMessagesMapHolder {
        private static final Map<Integer, String> MESSAGES_MAP = LoggingUtils.generateMnemonicMap(SshAgentConstants.class, f -> {
            String name = f.getName();
            return !name.startsWith("SSH_AGENT_CONSTRAIN") && (name.startsWith("SSH_AGENT") || name.startsWith("SSH2_AGENT"));
        });

        private LazyMessagesMapHolder() {
        }
    }
}

