/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.RegionDigraphPersistence;
import org.apache.karaf.features.internal.management.FeaturesServiceMBeanImpl;
import org.apache.karaf.features.internal.region.DigraphHelper;
import org.apache.karaf.features.internal.repository.AggregateRepository;
import org.apache.karaf.features.internal.repository.JsonRepository;
import org.apache.karaf.features.internal.repository.XmlRepository;
import org.apache.karaf.features.internal.resolver.Slf4jResolverLog;
import org.apache.karaf.features.internal.service.BootFeaturesInstaller;
import org.apache.karaf.features.internal.service.EventAdminListener;
import org.apache.karaf.features.internal.service.FeatureFinder;
import org.apache.karaf.features.internal.service.FeaturesServiceImpl;
import org.apache.karaf.features.internal.service.StateStorage;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.eclipse.equinox.internal.region.CollisionHookHelper;
import org.eclipse.equinox.internal.region.StandardRegionDigraph;
import org.eclipse.equinox.internal.region.management.StandardManageableRegionDigraph;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.repository.Repository;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.LoggerFactory;

@Services(requires={@RequireService(value=ConfigurationAdmin.class), @RequireService(value=URLStreamHandlerService.class, filter="(url.handler.protocol=mvn)")}, provides={@ProvideService(value=FeaturesService.class), @ProvideService(value=RegionDigraph.class), @ProvideService(value=RegionDigraphPersistence.class)})
public class Activator
extends BaseActivator {
    public static final String FEATURES_REPOS_PID = "org.apache.karaf.features.repos";
    public static final String FEATURES_SERVICE_CONFIG_FILE = "org.apache.karaf.features.cfg";
    private static final String STATE_FILE = "state.json";
    private ServiceTracker<FeaturesListener, FeaturesListener> featuresListenerTracker;
    private FeaturesServiceImpl featuresService;
    private StandardRegionDigraph digraph;
    private StandardManageableRegionDigraph digraphMBean;

    public Activator() {
        this.setSchedulerStopTimeout(0L);
    }

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
        Properties configuration = new Properties();
        File configFile = new File(System.getProperty("karaf.etc"), FEATURES_SERVICE_CONFIG_FILE);
        if (configFile.isFile() && configFile.canRead()) {
            try {
                configuration.load(new FileReader(configFile));
            }
            catch (IOException e) {
                this.logger.warn("Error reading configuration file " + configFile.toString(), (Throwable)e);
            }
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            ((Dictionary)props).put(entry.getKey(), entry.getValue());
        }
        this.updated(props);
    }

    @Override
    protected void doStart() throws Exception {
        EventAdminListener eventAdminListener;
        Repository globalRepository;
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        ResolverImpl resolver = new ResolverImpl(new Slf4jResolverLog(LoggerFactory.getLogger(ResolverImpl.class)));
        URLStreamHandlerService mvnUrlHandler = this.getTrackedService(URLStreamHandlerService.class);
        if (configurationAdmin == null || mvnUrlHandler == null) {
            return;
        }
        StandardRegionDigraph dg = this.digraph = DigraphHelper.loadDigraph(this.bundleContext);
        this.register(ResolverHookFactory.class, dg.getResolverHookFactory());
        this.register(CollisionHook.class, CollisionHookHelper.getCollisionHook(dg));
        this.register(FindHook.class, dg.getBundleFindHook());
        this.register(EventHook.class, dg.getBundleEventHook());
        this.register(org.osgi.framework.hooks.service.FindHook.class, dg.getServiceFindHook());
        this.register(org.osgi.framework.hooks.service.EventHook.class, dg.getServiceEventHook());
        this.register(RegionDigraph.class, dg);
        this.register(RegionDigraphPersistence.class, this::doPersistRegionDigraph);
        StandardManageableRegionDigraph dgmb = this.digraphMBean = new StandardManageableRegionDigraph(dg, "org.apache.karaf", this.bundleContext);
        dgmb.registerMBean();
        FeatureFinder featureFinder = new FeatureFinder();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", FEATURES_REPOS_PID);
        this.register(ManagedService.class, featureFinder, props);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        String[] resourceRepositories = this.getString("resourceRepositories", "").split(",");
        long repositoryExpiration = this.getLong("repositoryExpiration", 60000L);
        boolean repositoryIgnoreFailures = this.getBoolean("repositoryIgnoreFailures", true);
        for (String url : resourceRepositories) {
            if ((url = url.trim()).isEmpty()) continue;
            if (url.startsWith("json:")) {
                repositories.add(new JsonRepository(url.substring("json:".length()), repositoryExpiration, repositoryIgnoreFailures));
                continue;
            }
            if (url.startsWith("xml:")) {
                repositories.add(new XmlRepository(url.substring("xml:".length()), repositoryExpiration, repositoryIgnoreFailures));
                continue;
            }
            this.logger.warn("Unrecognized resource repository: " + url);
        }
        switch (repositories.size()) {
            case 0: {
                globalRepository = null;
                break;
            }
            case 1: {
                globalRepository = (Repository)repositories.get(0);
                break;
            }
            default: {
                globalRepository = new AggregateRepository(repositories);
            }
        }
        String overrides = this.getString("overrides", new File(System.getProperty("karaf.etc"), "overrides.properties").toURI().toString());
        String featureResolutionRange = this.getString("featureResolutionRange", "${range;[====,====]}");
        String bundleUpdateRange = this.getString("bundleUpdateRange", "${range;[==,=+)}");
        String updateSnapshots = this.getString("updateSnapshots", "crc");
        int downloadThreads = this.getInt("downloadThreads", 8);
        long scheduleDelay = this.getLong("scheduleDelay", 250L);
        int scheduleMaxRun = this.getInt("scheduleMaxRun", 9);
        String blacklisted = this.getString("blacklisted", new File(System.getProperty("karaf.etc"), "blacklisted.properties").toURI().toString());
        String serviceRequirements = this.getString("serviceRequirements", "default");
        boolean configCfgStore = this.getBoolean("configCfgStore", true);
        StateStorage stateStorage = new StateStorage(){

            @Override
            protected InputStream getInputStream() throws IOException {
                File file = Activator.this.bundleContext.getDataFile(Activator.STATE_FILE);
                if (file.exists()) {
                    return new FileInputStream(file);
                }
                return null;
            }

            @Override
            protected OutputStream getOutputStream() throws IOException {
                File file = Activator.this.bundleContext.getDataFile(Activator.STATE_FILE);
                return new FileOutputStream(file);
            }
        };
        try {
            eventAdminListener = new EventAdminListener(this.bundleContext);
        }
        catch (Throwable t) {
            eventAdminListener = null;
        }
        this.featuresService = new FeaturesServiceImpl(this.bundleContext.getBundle(), this.bundleContext, this.bundleContext.getBundle(0L).getBundleContext(), stateStorage, featureFinder, eventAdminListener, configurationAdmin, resolver, dg, overrides, featureResolutionRange, bundleUpdateRange, updateSnapshots, serviceRequirements, globalRepository, downloadThreads, scheduleDelay, scheduleMaxRun, blacklisted, configCfgStore);
        this.register(FeaturesService.class, this.featuresService);
        this.featuresListenerTracker = new ServiceTracker(this.bundleContext, FeaturesListener.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<FeaturesListener, FeaturesListener>(){

            public FeaturesListener addingService(ServiceReference<FeaturesListener> reference) {
                FeaturesListener service = (FeaturesListener)Activator.this.bundleContext.getService(reference);
                Activator.this.featuresService.registerListener(service);
                return service;
            }

            public void modifiedService(ServiceReference<FeaturesListener> reference, FeaturesListener service) {
            }

            public void removedService(ServiceReference<FeaturesListener> reference, FeaturesListener service) {
                Activator.this.featuresService.unregisterListener(service);
                Activator.this.bundleContext.ungetService(reference);
            }
        });
        this.featuresListenerTracker.open();
        FeaturesServiceMBeanImpl featuresServiceMBean = new FeaturesServiceMBeanImpl();
        featuresServiceMBean.setBundleContext(this.bundleContext);
        featuresServiceMBean.setFeaturesService(this.featuresService);
        this.registerMBean(featuresServiceMBean, "type=feature");
        String featuresRepositories = this.getString("featuresRepositories", "");
        String featuresBoot = this.getString("featuresBoot", "");
        boolean featuresBootAsynchronous = this.getBoolean("featuresBootAsynchronous", false);
        BootFeaturesInstaller bootFeaturesInstaller = new BootFeaturesInstaller(this.bundleContext, this.featuresService, featuresRepositories, featuresBoot, featuresBootAsynchronous);
        bootFeaturesInstaller.start();
    }

    @Override
    protected void doStop() {
        if (this.digraphMBean != null) {
            this.digraphMBean.unregisterMbean();
            this.digraphMBean = null;
        }
        if (this.featuresListenerTracker != null) {
            this.featuresListenerTracker.close();
            this.featuresListenerTracker = null;
        }
        super.doStop();
        if (this.featuresService != null) {
            this.featuresService.stop();
            this.featuresService = null;
        }
        if (this.digraph != null) {
            this.doPersistRegionDigraph();
            this.digraph = null;
        }
    }

    private void doPersistRegionDigraph() {
        if (this.digraph != null) {
            try {
                DigraphHelper.saveDigraph(this.bundleContext, this.digraph);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

