/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.SuiteRunner;
import org.testng.internal.Utils;
import org.testng.internal.remote.SlavePool;
import org.testng.remote.ConnectionInfo;
import org.testng.remote.RemoteWorker;
import org.testng.reporters.TestHTMLReporter;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestWorker
extends RemoteWorker
implements Runnable {
    private XmlSuite m_suite;
    private SuiteRunner m_suiteRunner;

    public RemoteTestWorker(XmlSuite suite, SlavePool slavePool, SuiteRunner suiteRunner, List<ISuite> result) {
        super(result, slavePool);
        this.m_suite = suite;
        this.m_suiteRunner = suiteRunner;
    }

    @Override
    public void run() {
        try {
            this.ppp(new StringBuffer().append("Running test ").append(this.m_suite.getName()).toString());
            ConnectionInfo slave = this.getSlavePool().getSlave();
            SuiteRunner remoteSuiteRunner = this.sendSuite(slave, this.m_suite);
            this.m_suiteRunner.setHost(remoteSuiteRunner.getHost());
            Map<String, ISuiteResult> tmpResults = remoteSuiteRunner.getResults();
            Map<String, ISuiteResult> suiteResults = this.m_suiteRunner.getResults();
            for (String tests : tmpResults.keySet()) {
                ISuiteResult suiteResult = tmpResults.get(tests);
                suiteResults.put(tests, suiteResult);
                ITestContext tc = suiteResult.getTestContext();
                TestHTMLReporter.generateLog(tc, remoteSuiteRunner.getHost(), this.m_suiteRunner.getOutputDirectory(), tc.getFailedConfigurations().getAllResults(), tc.getSkippedConfigurations().getAllResults(), tc.getPassedTests().getAllResults(), tc.getFailedTests().getAllResults(), tc.getSkippedTests().getAllResults(), tc.getFailedButWithinSuccessPercentageTests().getAllResults());
            }
            this.ppp(new StringBuffer().append("Received result for test ").append(this.m_suite.getName()).toString());
            this.getSlavePool().returnSlave(slave);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ppp(String s) {
        Utils.log("[RemoteTestWorker]", 2, s);
    }
}

