/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.coreit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class NoProjectMojo
extends AbstractMojo {
    private MavenProject project;
    private String outputDirectory;
    private Map pluginArtifacts;
    private File basedirAlignmentDirectory;
    private String pluginItem = "foo";
    private String goalItem = "bar";
    private String artifactToFile;

    public void execute() throws MojoExecutionException {
        this.touch(new File(this.outputDirectory), "touch.txt");
        if (this.basedirAlignmentDirectory.getPath().equals("target/test-basedir-alignment")) {
            throw new MojoExecutionException("basedirAlignmentDirectory not aligned");
        }
        this.touch(this.basedirAlignmentDirectory, "touch.txt");
        File outDir = new File(this.outputDirectory);
        if (this.pluginItem != null) {
            this.touch(outDir, this.pluginItem);
        }
        if (this.goalItem != null) {
            this.touch(outDir, this.goalItem);
        }
        if (this.artifactToFile != null) {
            Artifact artifact = (Artifact)this.pluginArtifacts.get(this.artifactToFile);
            File artifactFile = artifact.getFile();
            String filename = artifactFile.getAbsolutePath().replace('/', '_').replace(':', '_') + ".txt";
            this.touch(outDir, filename);
        }
        this.project.getBuild().setFinalName("coreitified");
    }

    private void touch(File dir, String file) throws MojoExecutionException {
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File touch = new File(dir, file);
            this.getLog().info((CharSequence)("Touching: " + touch));
            FileWriter w = new FileWriter(touch);
            w.write(file);
            w.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error touching file", (Exception)e);
        }
    }
}

