/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.IntIterator4bag;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;

public class FSBagIndex<T extends FeatureStructure>
extends FSLeafIndexImpl<T> {
    static final boolean USE_POSITIVE_INT_SET = !FSIndexRepositoryImpl.IS_ALLOW_DUP_ADD_2_INDEXES;
    private final IntVector index;
    private final PositiveIntSet indexP = USE_POSITIVE_INT_SET ? new PositiveIntSet_impl() : null;
    private int initialSize;

    FSBagIndex(CASImpl cas, Type type, int initialSize, int indexType) {
        super(cas, type, indexType);
        this.initialSize = initialSize;
        this.index = USE_POSITIVE_INT_SET ? null : new IntVector(initialSize);
    }

    @Override
    boolean init(FSIndexComparator comp) {
        FSIndexComparator newComp;
        if (comp.getNumberOfKeys() > 0) {
            newComp = new FSIndexComparatorImpl(this.lowLevelCAS);
            newComp.setType(comp.getType());
        } else {
            newComp = comp;
        }
        return super.init(newComp);
    }

    @Override
    public void flush() {
        if (USE_POSITIVE_INT_SET) {
            this.indexP.clear();
        } else if (this.index.size() > this.initialSize) {
            this.index.resetSize(this.initialSize);
        } else {
            this.index.removeAllElements();
        }
    }

    @Override
    public final boolean insert(int fs) {
        if (USE_POSITIVE_INT_SET) {
            return this.indexP.add(fs);
        }
        this.index.add(fs);
        return true;
    }

    private int find(int ele) {
        if (USE_POSITIVE_INT_SET) {
            return this.indexP.find(ele);
        }
        return this.index.indexOfOptimizeAscending(ele);
    }

    int findLeftmost(int ele) {
        if (USE_POSITIVE_INT_SET) {
            return this.indexP.find(ele);
        }
        return this.index.indexOf(ele);
    }

    @Override
    public int compare(int fs1, int fs2) {
        if (fs1 < fs2) {
            return -1;
        }
        if (fs1 > fs2) {
            return 1;
        }
        return 0;
    }

    @Override
    public ComparableIntPointerIterator<T> pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        return new IntIterator4bag(this, detectIllegalIndexUpdates);
    }

    @Override
    protected IntPointerIterator refIterator() {
        return new IntIterator4bag(this, null);
    }

    @Override
    public LowLevelIterator ll_iterator() {
        return new IntIterator4bag(this, null);
    }

    @Override
    protected IntPointerIterator refIterator(int fsCode) {
        IntIterator4bag it = new IntIterator4bag(this, null);
        it.moveTo(fsCode);
        return it;
    }

    public boolean contains(FeatureStructure fs) {
        return this.ll_contains(((FeatureStructureImpl)fs).getAddress());
    }

    boolean ll_contains(int fsAddr) {
        return USE_POSITIVE_INT_SET ? this.indexP.contains(fsAddr) : this.find(fsAddr) >= 0;
    }

    public FeatureStructure find(FeatureStructure fs) {
        if (USE_POSITIVE_INT_SET) {
            FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
            int addr = fsi.getAddress();
            return this.indexP.contains(addr) ? (FeatureStructure)fsi.getCASImpl().createFS(addr) : null;
        }
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        int resultAddr = this.find(fsi.getAddress());
        if (resultAddr > 0) {
            return fsi.getCASImpl().createFS(this.index.get(resultAddr));
        }
        return null;
    }

    @Override
    public int size() {
        return USE_POSITIVE_INT_SET ? this.indexP.size() : this.index.size();
    }

    @Override
    public void deleteFS(FeatureStructure fs) {
        this.remove(((FeatureStructureImpl)fs).getAddress());
    }

    @Override
    public boolean remove(int fsRef) {
        if (USE_POSITIVE_INT_SET) {
            return this.indexP.remove(fsRef);
        }
        int pos = this.index.indexOfOptimizeAscending(fsRef);
        if (pos >= 0) {
            this.index.remove(pos);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean insert(int fs, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void bulkAddTo(IntVector v) {
        if (USE_POSITIVE_INT_SET) {
            this.indexP.bulkAddTo(v);
        } else {
            v.addBulk(this.index);
        }
    }

    boolean isValid(int itPos) {
        if (USE_POSITIVE_INT_SET) {
            return this.indexP.isValid(itPos);
        }
        return itPos >= 0 && itPos < this.index.size();
    }

    int moveToFirst() {
        return USE_POSITIVE_INT_SET ? this.indexP.moveToFirst() : (this.index.size() == 0 ? -1 : 0);
    }

    int moveToLast() {
        return USE_POSITIVE_INT_SET ? this.indexP.moveToLast() : this.index.size() - 1;
    }

    int moveToNext(int itPos) {
        return USE_POSITIVE_INT_SET ? this.indexP.moveToNext(itPos) : (itPos < 0 ? -1 : itPos + 1);
    }

    int moveToPrevious(int itPos) {
        return USE_POSITIVE_INT_SET ? this.indexP.moveToPrevious(itPos) : (itPos >= this.index.size() ? -1 : itPos - 1);
    }

    int get(int itPos) {
        return USE_POSITIVE_INT_SET ? this.indexP.get(itPos) : this.index.get(itPos);
    }
}

