/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.MutableAce;
import org.apache.chemistry.opencmis.commons.data.MutableAcl;
import org.apache.chemistry.opencmis.commons.data.MutableContentStream;
import org.apache.chemistry.opencmis.commons.data.MutableProperties;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyData;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyHtml;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyId;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyInteger;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyString;
import org.apache.chemistry.opencmis.commons.data.MutablePropertyUri;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;

public class BindingsObjectFactoryImpl
implements BindingsObjectFactory,
Serializable {
    private static final long serialVersionUID = 1L;

    public MutableAce createAccessControlEntry(String principal, List<String> permissions) {
        return new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principal), permissions);
    }

    public MutableAcl createAccessControlList(List<Ace> aces) {
        return new AccessControlListImpl(aces);
    }

    public MutableContentStream createContentStream(String filename, BigInteger length, String mimetype, InputStream stream) {
        return new ContentStreamImpl(filename, length, mimetype, stream);
    }

    public MutableProperties createPropertiesData(List<PropertyData<?>> properties) {
        return new PropertiesImpl(properties);
    }

    public <T> MutablePropertyData<T> createPropertyData(PropertyDefinition<T> pd, Object value) {
        boolean single;
        String id = pd.getId();
        boolean bl = single = pd.getCardinality() == Cardinality.SINGLE;
        if (pd instanceof PropertyBooleanDefinition) {
            if (single) {
                return this.createPropertyBooleanData(id, (Boolean)value);
            }
            return this.createPropertyBooleanData(id, (List<Boolean>)((List)value));
        }
        if (pd instanceof PropertyDateTimeDefinition) {
            if (single) {
                return this.createPropertyDateTimeData(id, (GregorianCalendar)value);
            }
            return this.createPropertyDateTimeData(id, (List<GregorianCalendar>)((List)value));
        }
        if (pd instanceof PropertyDecimalDefinition) {
            if (single) {
                return this.createPropertyDecimalData(id, (BigDecimal)value);
            }
            return this.createPropertyDecimalData(id, (List<BigDecimal>)((List)value));
        }
        if (pd instanceof PropertyHtmlDefinition) {
            if (single) {
                return this.createPropertyHtmlData(id, (String)value);
            }
            return this.createPropertyHtmlData(id, (List<String>)((List)value));
        }
        if (pd instanceof PropertyIdDefinition) {
            if (single) {
                return this.createPropertyIdData(id, (String)value);
            }
            return this.createPropertyIdData(id, (List<String>)((List)value));
        }
        if (pd instanceof PropertyIntegerDefinition) {
            if (single) {
                return this.createPropertyIntegerData(id, (BigInteger)value);
            }
            return this.createPropertyIntegerData(id, (List<BigInteger>)((List)value));
        }
        if (pd instanceof PropertyStringDefinition) {
            if (single) {
                return this.createPropertyStringData(id, (String)value);
            }
            return this.createPropertyStringData(id, (List<String>)((List)value));
        }
        if (pd instanceof PropertyUriDefinition) {
            if (single) {
                return this.createPropertyUriData(id, (String)value);
            }
            return this.createPropertyUriData(id, (List<String>)((List)value));
        }
        throw new CmisRuntimeException("Unknown property definition: " + pd);
    }

    public MutablePropertyBoolean createPropertyBooleanData(String id, List<Boolean> values) {
        return new PropertyBooleanImpl(id, values);
    }

    public MutablePropertyBoolean createPropertyBooleanData(String id, Boolean value) {
        return new PropertyBooleanImpl(id, value);
    }

    public MutablePropertyDateTime createPropertyDateTimeData(String id, List<GregorianCalendar> values) {
        return new PropertyDateTimeImpl(id, values);
    }

    public MutablePropertyDateTime createPropertyDateTimeData(String id, GregorianCalendar value) {
        return new PropertyDateTimeImpl(id, value);
    }

    public MutablePropertyDecimal createPropertyDecimalData(String id, List<BigDecimal> values) {
        return new PropertyDecimalImpl(id, values);
    }

    public MutablePropertyDecimal createPropertyDecimalData(String id, BigDecimal value) {
        return new PropertyDecimalImpl(id, value);
    }

    public MutablePropertyHtml createPropertyHtmlData(String id, List<String> values) {
        return new PropertyHtmlImpl(id, values);
    }

    public MutablePropertyHtml createPropertyHtmlData(String id, String value) {
        return new PropertyHtmlImpl(id, value);
    }

    public MutablePropertyId createPropertyIdData(String id, List<String> values) {
        return new PropertyIdImpl(id, values);
    }

    public MutablePropertyId createPropertyIdData(String id, String value) {
        return new PropertyIdImpl(id, value);
    }

    public MutablePropertyInteger createPropertyIntegerData(String id, List<BigInteger> values) {
        return new PropertyIntegerImpl(id, values);
    }

    public MutablePropertyInteger createPropertyIntegerData(String id, BigInteger value) {
        return new PropertyIntegerImpl(id, value);
    }

    public MutablePropertyString createPropertyStringData(String id, List<String> values) {
        return new PropertyStringImpl(id, values);
    }

    public MutablePropertyString createPropertyStringData(String id, String value) {
        return new PropertyStringImpl(id, value);
    }

    public MutablePropertyUri createPropertyUriData(String id, List<String> values) {
        return new PropertyUriImpl(id, values);
    }

    public MutablePropertyUri createPropertyUriData(String id, String value) {
        return new PropertyUriImpl(id, value);
    }
}

