/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.util.Arrays;
import junit.textui.TestRunner;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLIdentifier;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactTestCase;
import org.opensaml.artifact.SAMLArtifactType0001;
import org.opensaml.artifact.Util;

public class SAMLArtifactType0001Test
extends ArtifactTestCase {
    private static String providerIdStr = null;
    private static SAMLIdentifier idgen = null;

    public SAMLArtifactType0001Test() {
    }

    public SAMLArtifactType0001Test(String arg) {
        super(arg);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            providerIdStr = args[0];
        }
        TestRunner.run(SAMLArtifactType0001Test.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        idgen = SAMLConfig.instance().getDefaultIDProvider();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSAMLArtifactType0001() throws Exception {
        byte[] sourceId;
        if (providerIdStr == null) {
            sourceId = idgen.generateRandomBytes(20);
        } else {
            sourceId = Util.generateSourceId(providerIdStr);
        }
        SAMLArtifactType0001 artifact = new SAMLArtifactType0001(sourceId);
        Artifact tempArtifact = ArtifactTestCase.duplicate(artifact);
        byte[] sourceId1 = artifact.getSourceId();
        byte[] sourceId2 = ((SAMLArtifactType0001)tempArtifact).getSourceId();
        SAMLArtifactType0001Test.assertTrue((String)"SourceIds not equal", (boolean)Arrays.equals(sourceId1, sourceId2));
        byte[] handle1 = artifact.getAssertionHandle();
        byte[] handle2 = ((SAMLArtifactType0001)tempArtifact).getAssertionHandle();
        SAMLArtifactType0001Test.assertTrue((String)"Assertion handles not equal", (boolean)Arrays.equals(handle1, handle2));
        sourceId = Util.concat(sourceId1, sourceId2);
        try {
            artifact = new SAMLArtifactType0001(sourceId, handle1);
            SAMLArtifactType0001Test.assertTrue((String)"Invalid sourceId did not throw exception", (boolean)true);
        }
        catch (Exception e) {
            SAMLArtifactType0001Test.assertTrue((String)"Wrong exception type for invalid sourceId", (boolean)(e instanceof IllegalArgumentException));
        }
        byte[] assertionHandle = Util.concat(handle1, handle2);
        try {
            artifact = new SAMLArtifactType0001(sourceId1, assertionHandle);
            SAMLArtifactType0001Test.assertTrue((String)"Invalid assertionHandle did not throw exception", (boolean)true);
        }
        catch (Exception e) {
            SAMLArtifactType0001Test.assertTrue((String)"Wrong exception type for invalid assertionHandle", (boolean)(e instanceof IllegalArgumentException));
        }
    }
}

