/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.luke.models.documents.DocValues;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.util.BytesRef;

final class DocValuesAdapter {
    private final IndexReader reader;

    DocValuesAdapter(IndexReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    Optional<DocValues> getDocValues(int docid, String field) throws IOException {
        DocValuesType dvType = IndexUtils.getFieldInfo(this.reader, field).getDocValuesType();
        switch (dvType) {
            case BINARY: {
                return this.createBinaryDocValues(docid, field, DocValuesType.BINARY);
            }
            case NUMERIC: {
                return this.createNumericDocValues(docid, field, DocValuesType.NUMERIC);
            }
            case SORTED_NUMERIC: {
                return this.createSortedNumericDocValues(docid, field, DocValuesType.SORTED_NUMERIC);
            }
            case SORTED: {
                return this.createSortedDocValues(docid, field, DocValuesType.SORTED);
            }
            case SORTED_SET: {
                return this.createSortedSetDocValues(docid, field, DocValuesType.SORTED_SET);
            }
        }
        return Optional.empty();
    }

    private Optional<DocValues> createBinaryDocValues(int docid, String field, DocValuesType dvType) throws IOException {
        BinaryDocValues bvalues = IndexUtils.getBinaryDocValues(this.reader, field);
        if (bvalues.advanceExact(docid)) {
            DocValues dv = DocValues.of(dvType, Collections.singletonList(BytesRef.deepCopyOf((BytesRef)bvalues.binaryValue())), Collections.emptyList());
            return Optional.of(dv);
        }
        return Optional.empty();
    }

    private Optional<DocValues> createNumericDocValues(int docid, String field, DocValuesType dvType) throws IOException {
        NumericDocValues nvalues = IndexUtils.getNumericDocValues(this.reader, field);
        if (nvalues.advanceExact(docid)) {
            DocValues dv = DocValues.of(dvType, Collections.emptyList(), Collections.singletonList(nvalues.longValue()));
            return Optional.of(dv);
        }
        return Optional.empty();
    }

    private Optional<DocValues> createSortedNumericDocValues(int docid, String field, DocValuesType dvType) throws IOException {
        SortedNumericDocValues snvalues = IndexUtils.getSortedNumericDocValues(this.reader, field);
        if (snvalues.advanceExact(docid)) {
            ArrayList<Long> numericValues = new ArrayList<Long>();
            int dvCount = snvalues.docValueCount();
            for (int i = 0; i < dvCount; ++i) {
                numericValues.add(snvalues.nextValue());
            }
            DocValues dv = DocValues.of(dvType, Collections.emptyList(), numericValues);
            return Optional.of(dv);
        }
        return Optional.empty();
    }

    private Optional<DocValues> createSortedDocValues(int docid, String field, DocValuesType dvType) throws IOException {
        SortedDocValues svalues = IndexUtils.getSortedDocValues(this.reader, field);
        if (svalues.advanceExact(docid)) {
            DocValues dv = DocValues.of(dvType, Collections.singletonList(BytesRef.deepCopyOf((BytesRef)svalues.lookupOrd(svalues.ordValue()))), Collections.emptyList());
            return Optional.of(dv);
        }
        return Optional.empty();
    }

    private Optional<DocValues> createSortedSetDocValues(int docid, String field, DocValuesType dvType) throws IOException {
        SortedSetDocValues ssvalues = IndexUtils.getSortedSetDocvalues(this.reader, field);
        if (ssvalues.advanceExact(docid)) {
            ArrayList<BytesRef> values = new ArrayList<BytesRef>();
            for (int i = 0; i < ssvalues.docValueCount(); ++i) {
                values.add(BytesRef.deepCopyOf((BytesRef)ssvalues.lookupOrd(ssvalues.nextOrd())));
            }
            DocValues dv = DocValues.of(dvType, values, Collections.emptyList());
            return Optional.of(dv);
        }
        return Optional.empty();
    }
}

