/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;

public class DefaultPassageFormatter
extends PassageFormatter {
    protected final String preTag;
    protected final String postTag;
    protected final String ellipsis;
    protected final boolean escape;

    public DefaultPassageFormatter() {
        this("<b>", "</b>", "... ", false);
    }

    public DefaultPassageFormatter(String preTag, String postTag, String ellipsis, boolean escape) {
        if (preTag == null || postTag == null || ellipsis == null) {
            throw new NullPointerException();
        }
        this.preTag = preTag;
        this.postTag = postTag;
        this.ellipsis = ellipsis;
        this.escape = escape;
    }

    @Override
    public String format(Passage[] passages, String content) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (Passage passage : passages) {
            if (!sb.isEmpty() && passage.getStartOffset() != pos) {
                sb.append(this.ellipsis);
            }
            pos = passage.getStartOffset();
            for (int i = 0; i < passage.getNumMatches(); ++i) {
                int start = passage.getMatchStarts()[i];
                assert (start >= pos && start < passage.getEndOffset());
                this.append(sb, content, pos, start);
                int end = passage.getMatchEnds()[i];
                assert (end > start);
                while (i + 1 < passage.getNumMatches() && passage.getMatchStarts()[i + 1] < end) {
                    end = Math.max(end, passage.getMatchEnds()[++i]);
                }
                end = Math.min(end, passage.getEndOffset());
                sb.append(this.preTag);
                this.append(sb, content, start, end);
                sb.append(this.postTag);
                pos = end;
            }
            this.append(sb, content, pos, Math.max(pos, passage.getEndOffset()));
            pos = passage.getEndOffset();
        }
        return sb.toString();
    }

    protected void append(StringBuilder dest, String content, int start, int end) {
        if (this.escape) {
            block8: for (int i = start; i < end; ++i) {
                char ch = content.charAt(i);
                switch (ch) {
                    case '&': {
                        dest.append("&amp;");
                        continue block8;
                    }
                    case '<': {
                        dest.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        dest.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        dest.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        dest.append("&#x27;");
                        continue block8;
                    }
                    case '/': {
                        dest.append("&#x2F;");
                        continue block8;
                    }
                    default: {
                        dest.append(ch);
                    }
                }
            }
        } else {
            dest.append(content, start, end);
        }
    }
}

