/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.luke.util.CircularLogBufferHandler;

public class LogRecordFormatter
implements Function<CircularLogBufferHandler.ImmutableLogRecord, String> {
    @Override
    public String apply(CircularLogBufferHandler.ImmutableLogRecord record) {
        return String.format(Locale.ROOT, "%s [%s] %s: %s", DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT).format(record.getInstant().atZone(ZoneId.systemDefault())), record.getLevel(), record.getLoggerName(), record.getMessage() + (String)(record.getThrown() == null ? "" : "\n" + this.toString(record.getThrown())));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String toString(Throwable t) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                pw.flush();
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "Could not dump stack trace: " + e.getMessage();
        }
    }
}

