/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.VectorUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=1)
@Warmup(iterations=3, time=3)
@Measurement(iterations=5, time=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class HammingDistanceBenchmark {
    @Param(value={"1000000"})
    int nb = 1000000;
    @Param(value={"1024"})
    int dims = 1024;
    byte[][] xb;
    byte[] xq;

    @Setup
    public void setup() throws IOException {
        int i;
        Random rand = new Random();
        this.xb = new byte[this.nb][this.dims / 8];
        for (i = 0; i < this.nb; ++i) {
            for (int j = 0; j < this.dims / 8; ++j) {
                this.xb[i][j] = (byte)rand.nextInt(0, 255);
            }
        }
        this.xq = new byte[this.dims / 8];
        for (i = 0; i < this.xq.length; ++i) {
            this.xq[i] = (byte)rand.nextInt(0, 255);
        }
    }

    @Benchmark
    public int xorBitCount() {
        int tot = 0;
        for (int i = 0; i < this.nb; ++i) {
            tot += VectorUtil.xorBitCount((byte[])this.xb[i], (byte[])this.xq);
        }
        return tot;
    }
}

