/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.lucene103.Lucene103PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.TermState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class DeltaBaseTermStateSerializer
implements Accountable {
    private static final long RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(DeltaBaseTermStateSerializer.class);
    private static final long INT_BLOCK_TERM_STATE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(Lucene103PostingsFormat.IntBlockTermState.class);
    protected long baseDocStartFP;
    protected long basePosStartFP;
    protected long basePayStartFP;

    public DeltaBaseTermStateSerializer() {
        this.resetBaseStartFP();
    }

    public void resetBaseStartFP() {
        this.baseDocStartFP = 0L;
        this.basePosStartFP = 0L;
        this.basePayStartFP = 0L;
    }

    public long getBaseDocStartFP() {
        return this.baseDocStartFP;
    }

    public long getBasePosStartFP() {
        return this.basePosStartFP;
    }

    public long getBasePayStartFP() {
        return this.basePayStartFP;
    }

    public void writeTermState(DataOutput termStatesOutput, FieldInfo fieldInfo, BlockTermState termState) throws IOException {
        IndexOptions indexOptions = fieldInfo.getIndexOptions();
        boolean hasFreqs = indexOptions != IndexOptions.DOCS;
        boolean hasPositions = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean hasOffsets = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean hasPayloads = fieldInfo.hasPayloads();
        Lucene103PostingsFormat.IntBlockTermState intTermState = (Lucene103PostingsFormat.IntBlockTermState)termState;
        termStatesOutput.writeVInt(intTermState.docFreq);
        if (hasFreqs) {
            assert (intTermState.totalTermFreq >= (long)intTermState.docFreq);
            termStatesOutput.writeVLong(intTermState.totalTermFreq - (long)intTermState.docFreq);
        }
        if (intTermState.singletonDocID != -1) {
            termStatesOutput.writeVInt(intTermState.singletonDocID);
        } else {
            if (this.baseDocStartFP == 0L) {
                this.baseDocStartFP = intTermState.docStartFP;
            }
            termStatesOutput.writeVLong(intTermState.docStartFP - this.baseDocStartFP);
        }
        if (hasPositions) {
            if (this.basePosStartFP == 0L) {
                this.basePosStartFP = intTermState.posStartFP;
            }
            termStatesOutput.writeVLong(intTermState.posStartFP - this.basePosStartFP);
            if (hasPayloads || hasOffsets) {
                if (this.basePayStartFP == 0L) {
                    this.basePayStartFP = intTermState.payStartFP;
                }
                termStatesOutput.writeVLong(intTermState.payStartFP - this.basePayStartFP);
            }
            if (intTermState.lastPosBlockOffset != -1L) {
                termStatesOutput.writeVLong(intTermState.lastPosBlockOffset);
            }
        }
    }

    public BlockTermState readTermState(long baseDocStartFP, long basePosStartFP, long basePayStartFP, DataInput termStatesInput, FieldInfo fieldInfo, BlockTermState reuse) throws IOException {
        IndexOptions indexOptions = fieldInfo.getIndexOptions();
        boolean hasFreqs = indexOptions != IndexOptions.DOCS;
        boolean hasPositions = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        Lucene103PostingsFormat.IntBlockTermState intTermState = reuse != null ? this.reset((Lucene103PostingsFormat.IntBlockTermState)reuse) : new Lucene103PostingsFormat.IntBlockTermState();
        intTermState.docFreq = termStatesInput.readVInt();
        long l = intTermState.totalTermFreq = hasFreqs ? (long)intTermState.docFreq + termStatesInput.readVLong() : (long)intTermState.docFreq;
        assert (intTermState.totalTermFreq >= (long)intTermState.docFreq);
        if (intTermState.docFreq == 1) {
            intTermState.singletonDocID = termStatesInput.readVInt();
        } else {
            intTermState.docStartFP = baseDocStartFP + termStatesInput.readVLong();
        }
        if (hasPositions) {
            boolean hasOffsets;
            intTermState.posStartFP = basePosStartFP + termStatesInput.readVLong();
            boolean bl = hasOffsets = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            if (hasOffsets || fieldInfo.hasPayloads()) {
                intTermState.payStartFP = basePayStartFP + termStatesInput.readVLong();
            }
            if (intTermState.totalTermFreq > 128L) {
                intTermState.lastPosBlockOffset = termStatesInput.readVLong();
            }
        }
        return intTermState;
    }

    protected Lucene103PostingsFormat.IntBlockTermState reset(Lucene103PostingsFormat.IntBlockTermState termState) {
        termState.ord = 0L;
        termState.docFreq = 0;
        termState.totalTermFreq = 0L;
        termState.termBlockOrd = 0;
        termState.blockFilePointer = 0L;
        termState.docStartFP = 0L;
        termState.posStartFP = 0L;
        termState.payStartFP = 0L;
        termState.lastPosBlockOffset = -1L;
        termState.singletonDocID = -1;
        return termState;
    }

    public long ramBytesUsed() {
        return RAM_USAGE;
    }

    public static long ramBytesUsed(TermState termState) {
        return termState instanceof Lucene103PostingsFormat.IntBlockTermState ? INT_BLOCK_TERM_STATE_RAM_USAGE : RamUsageEstimator.shallowSizeOf((Object)termState);
    }
}

