/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.AssertingLeafCollector;

public class AssertingCollector
extends FilterCollector {
    private boolean weightSet = false;
    private int maxDoc = -1;
    private int previousLeafMaxDoc = 0;
    public boolean hasFinishedCollectingPreviousLeaf = true;

    public static AssertingCollector wrap(Collector in) {
        if (in instanceof AssertingCollector) {
            return (AssertingCollector)in;
        }
        return new AssertingCollector(in);
    }

    private AssertingCollector(Collector in) {
        super(in);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        assert (this.weightSet) : "Set the weight first";
        assert (context.docBase >= this.previousLeafMaxDoc);
        this.previousLeafMaxDoc = context.docBase + context.reader().maxDoc();
        assert (this.hasFinishedCollectingPreviousLeaf);
        LeafCollector in = super.getLeafCollector(context);
        this.hasFinishedCollectingPreviousLeaf = false;
        final int docBase = context.docBase;
        return new AssertingLeafCollector(in, 0, Integer.MAX_VALUE){

            @Override
            public void collect(int doc) throws IOException {
                assert (docBase + doc >= AssertingCollector.this.maxDoc) : "collection is not in order: current doc=" + (docBase + doc) + " while " + AssertingCollector.this.maxDoc + " has already been collected";
                super.collect(doc);
                AssertingCollector.this.maxDoc = docBase + doc;
            }

            @Override
            public void finish() throws IOException {
                AssertingCollector.this.hasFinishedCollectingPreviousLeaf = true;
                super.finish();
            }
        };
    }

    public void setWeight(Weight weight) {
        assert (!this.weightSet) : "Weight set twice";
        this.weightSet = true;
        assert (weight != null);
        this.in.setWeight(weight);
    }
}

