/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.tests.index.AssertingDirectoryReader;
import org.apache.lucene.tests.index.MismatchedLeafReader;

public class MismatchedDirectoryReader
extends FilterDirectoryReader {
    public MismatchedDirectoryReader(DirectoryReader in, Random random) throws IOException {
        super(in, (FilterDirectoryReader.SubReaderWrapper)new MismatchedSubReaderWrapper(random));
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new AssertingDirectoryReader(in);
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static class MismatchedSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        final Random random;

        MismatchedSubReaderWrapper(Random random) {
            this.random = random;
        }

        public LeafReader wrap(LeafReader reader) {
            return new MismatchedLeafReader(reader, this.random);
        }
    }
}

