/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderFineGrainedReportListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderModelLoader;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderEvaluator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenNameFinderEvaluatorTool
extends AbstractEvaluatorTool<NameSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(TokenNameFinderEvaluatorTool.class);

    public TokenNameFinderEvaluatorTool() {
        super(NameSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the NameFinder model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        TokenNameFinderModel model = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<TokenNameFinderEvaluationMonitor> listeners = new LinkedList<TokenNameFinderEvaluationMonitor>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        TokenNameFinderFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new TokenNameFinderFineGrainedReportListener(model.getSequenceCodec(), reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating Name Finder fine-grained report file: " + e.getMessage());
            }
        }
        if (((EvalToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((EvalToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, (ObjectStream<NameSample>)this.sampleStream);
        }
        TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(new NameFinderME(model), listeners.toArray(new TokenNameFinderEvaluationMonitor[0]));
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        try (ObjectStream<NameSample> measuredSampleStream = new ObjectStream<NameSample>(){

            @Override
            public NameSample read() throws IOException {
                monitor.incrementCounter();
                return (NameSample)TokenNameFinderEvaluatorTool.this.sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                TokenNameFinderEvaluatorTool.this.sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                TokenNameFinderEvaluatorTool.this.sampleStream.close();
            }
        };){
            monitor.startAndPrintThroughput();
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        monitor.stopAndPrintFinalResult();
        if (reportFile != null) {
            reportListener.writeReport();
        }
        logger.info(evaluator.getFMeasure().toString());
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    FineGrainedEvaluatorParams {
        @ArgumentParser.OptionalParameter
        @ArgumentParser.ParameterDescription(valueName="types", description="name types to use for evaluation")
        public String getNameTypes();
    }
}

