/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;

public class BlockTermsWriter
extends FieldsConsumer {
    static final String CODEC_NAME = "BlockTermsWriter";
    public static final int VERSION_START = 4;
    public static final int VERSION_CURRENT = 4;
    static final String TERMS_EXTENSION = "tib";
    protected IndexOutput out;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    FieldInfo currentField;
    private final TermsIndexWriterBase termsIndexWriter;
    private final int maxDoc;
    private final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTermsWriter(TermsIndexWriterBase termsIndexWriter, SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
        this.termsIndexWriter = termsIndexWriter;
        this.maxDoc = state.segmentInfo.maxDoc();
        this.out = state.directory.createOutput(termsFileName, state.context);
        boolean success = false;
        try {
            this.fieldInfos = state.fieldInfos;
            CodecUtil.writeIndexHeader((DataOutput)this.out, (String)CODEC_NAME, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            this.currentField = null;
            this.postingsWriter = postingsWriter;
            postingsWriter.init(this.out, state);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    public void write(Fields fields, NormsProducer norms) throws IOException {
        for (String field : fields) {
            BytesRef term;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = this.addField(this.fieldInfos.fieldInfo(field));
            while ((term = termsEnum.next()) != null) {
                termsWriter.write(term, termsEnum, norms);
            }
            termsWriter.finish();
        }
    }

    private TermsWriter addField(FieldInfo field) throws IOException {
        assert (this.currentField == null || this.currentField.name.compareTo(field.name) < 0);
        this.currentField = field;
        TermsIndexWriterBase.FieldWriter fieldIndexWriter = this.termsIndexWriter.addField(field, this.out.getFilePointer());
        return new TermsWriter(fieldIndexWriter, field, this.postingsWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.out != null) {
            try {
                long dirStart = this.out.getFilePointer();
                this.out.writeVInt(this.fields.size());
                for (FieldMetaData field : this.fields) {
                    this.out.writeVInt(field.fieldInfo.number);
                    this.out.writeVLong(field.numTerms);
                    this.out.writeVLong(field.termsStartPointer);
                    if (field.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                        this.out.writeVLong(field.sumTotalTermFreq);
                    }
                    this.out.writeVLong(field.sumDocFreq);
                    this.out.writeVInt(field.docCount);
                }
                this.writeTrailer(dirStart);
                CodecUtil.writeFooter((IndexOutput)this.out);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter, this.termsIndexWriter});
                this.out = null;
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter, this.termsIndexWriter});
            this.out = null;
        }
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    class TermsWriter {
        private final FieldInfo fieldInfo;
        private final PostingsWriterBase postingsWriter;
        private final long termsStartPointer;
        private long numTerms;
        private final TermsIndexWriterBase.FieldWriter fieldIndexWriter;
        private final FixedBitSet docsSeen;
        long sumTotalTermFreq;
        long sumDocFreq;
        int docCount;
        private TermEntry[] pendingTerms;
        private int pendingCount;
        private final BytesRefBuilder lastPrevTerm = new BytesRefBuilder();
        private final ByteBuffersDataOutput bytesWriter = ByteBuffersDataOutput.newResettableInstance();

        TermsWriter(TermsIndexWriterBase.FieldWriter fieldIndexWriter, FieldInfo fieldInfo, PostingsWriterBase postingsWriter) {
            this.fieldInfo = fieldInfo;
            this.fieldIndexWriter = fieldIndexWriter;
            this.docsSeen = new FixedBitSet(BlockTermsWriter.this.maxDoc);
            this.pendingTerms = new TermEntry[32];
            for (int i = 0; i < this.pendingTerms.length; ++i) {
                this.pendingTerms[i] = new TermEntry();
            }
            this.termsStartPointer = BlockTermsWriter.this.out.getFilePointer();
            this.postingsWriter = postingsWriter;
            postingsWriter.setField(fieldInfo);
        }

        void write(BytesRef text, TermsEnum termsEnum, NormsProducer norms) throws IOException {
            BlockTermState state = this.postingsWriter.writeTerm(text, termsEnum, this.docsSeen, norms);
            if (state == null) {
                return;
            }
            this.sumDocFreq += (long)state.docFreq;
            this.sumTotalTermFreq += state.totalTermFreq;
            assert (state.docFreq > 0);
            TermStats stats = new TermStats(state.docFreq, state.totalTermFreq);
            boolean isIndexTerm = this.fieldIndexWriter.checkIndexTerm(text, stats);
            if (isIndexTerm) {
                if (this.pendingCount > 0) {
                    this.flushBlock();
                }
                this.fieldIndexWriter.add(text, stats, BlockTermsWriter.this.out.getFilePointer());
            }
            this.pendingTerms = (TermEntry[])ArrayUtil.grow((Object[])this.pendingTerms, (int)(this.pendingCount + 1));
            for (int i = this.pendingCount; i < this.pendingTerms.length; ++i) {
                this.pendingTerms[i] = new TermEntry();
            }
            TermEntry te = this.pendingTerms[this.pendingCount];
            te.term.copyBytes(text);
            te.state = state;
            ++this.pendingCount;
            ++this.numTerms;
        }

        void finish() throws IOException {
            if (this.pendingCount > 0) {
                this.flushBlock();
            }
            BlockTermsWriter.this.out.writeVInt(0);
            this.fieldIndexWriter.finish(BlockTermsWriter.this.out.getFilePointer());
            if (this.numTerms > 0L) {
                BlockTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, this.termsStartPointer, this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0 ? this.sumTotalTermFreq : -1L, this.sumDocFreq, this.docsSeen.cardinality()));
            }
        }

        private int sharedPrefix(BytesRef term1, BytesRef term2) {
            assert (term1.offset == 0);
            assert (term2.offset == 0);
            int pos1 = 0;
            int pos1End = pos1 + Math.min(term1.length, term2.length);
            int pos2 = 0;
            while (pos1 < pos1End) {
                if (term1.bytes[pos1] != term2.bytes[pos2]) {
                    return pos1;
                }
                ++pos1;
                ++pos2;
            }
            return pos1;
        }

        private void flushBlock() throws IOException {
            int termCount;
            int commonPrefix = this.sharedPrefix(this.lastPrevTerm.get(), this.pendingTerms[0].term.get());
            for (termCount = 1; termCount < this.pendingCount; ++termCount) {
                commonPrefix = Math.min(commonPrefix, this.sharedPrefix(this.lastPrevTerm.get(), this.pendingTerms[termCount].term.get()));
            }
            BlockTermsWriter.this.out.writeVInt(this.pendingCount);
            BlockTermsWriter.this.out.writeVInt(commonPrefix);
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                int suffix = this.pendingTerms[termCount].term.length() - commonPrefix;
                this.bytesWriter.writeVInt(suffix);
                this.bytesWriter.writeBytes(this.pendingTerms[termCount].term.bytes(), commonPrefix, suffix);
            }
            BlockTermsWriter.this.out.writeVInt(Math.toIntExact(this.bytesWriter.size()));
            this.bytesWriter.copyTo((DataOutput)BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                BlockTermState state = this.pendingTerms[termCount].state;
                assert (state != null);
                this.bytesWriter.writeVInt(state.docFreq);
                if (this.fieldInfo.getIndexOptions() == IndexOptions.DOCS) continue;
                this.bytesWriter.writeVLong(state.totalTermFreq - (long)state.docFreq);
            }
            BlockTermsWriter.this.out.writeVInt(Math.toIntExact(this.bytesWriter.size()));
            this.bytesWriter.copyTo((DataOutput)BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            boolean absolute = true;
            for (int termCount2 = 0; termCount2 < this.pendingCount; ++termCount2) {
                BlockTermState state = this.pendingTerms[termCount2].state;
                this.postingsWriter.encodeTerm((DataOutput)this.bytesWriter, this.fieldInfo, state, absolute);
                absolute = false;
            }
            BlockTermsWriter.this.out.writeVInt(Math.toIntExact(this.bytesWriter.size()));
            this.bytesWriter.copyTo((DataOutput)BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            this.lastPrevTerm.copyBytes(this.pendingTerms[this.pendingCount - 1].term);
            this.pendingCount = 0;
        }
    }

    private record FieldMetaData(FieldInfo fieldInfo, long numTerms, long termsStartPointer, long sumTotalTermFreq, long sumDocFreq, int docCount) {
        private FieldMetaData {
            assert (numTerms > 0L);
        }
    }

    private static class TermEntry {
        public final BytesRefBuilder term = new BytesRefBuilder();
        public BlockTermState state;

        private TermEntry() {
        }
    }
}

