/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutProperties;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceElementResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceElementResolverStringSubstitutor;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverInterceptor;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

final class StackTraceElementResolverContext
implements TemplateResolverContext<StackTraceElement, StackTraceElementResolverContext> {
    private final Map<String, StackTraceElementResolverFactory> resolverFactoryByName;
    private final StackTraceElementResolverStringSubstitutor substitutor;
    private final JsonWriter jsonWriter;
    private final JsonTemplateLayoutProperties defaults;

    private StackTraceElementResolverContext(Builder builder) {
        this.resolverFactoryByName = builder.resolverFactoryByName;
        this.substitutor = builder.substitutor;
        this.jsonWriter = builder.jsonWriter;
        this.defaults = builder.defaults;
    }

    @Override
    public final Class<StackTraceElementResolverContext> getContextClass() {
        return StackTraceElementResolverContext.class;
    }

    @Override
    public Map<String, StackTraceElementResolverFactory> getResolverFactoryByName() {
        return this.resolverFactoryByName;
    }

    @Override
    public List<? extends TemplateResolverInterceptor<StackTraceElement, StackTraceElementResolverContext>> getResolverInterceptors() {
        return Collections.emptyList();
    }

    public StackTraceElementResolverStringSubstitutor getSubstitutor() {
        return this.substitutor;
    }

    @Override
    public JsonWriter getJsonWriter() {
        return this.jsonWriter;
    }

    @Override
    public JsonTemplateLayoutProperties getDefaults() {
        return this.defaults;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder {
        private Map<String, StackTraceElementResolverFactory> resolverFactoryByName;
        private StackTraceElementResolverStringSubstitutor substitutor;
        private JsonWriter jsonWriter;
        private JsonTemplateLayoutProperties defaults;

        private Builder() {
        }

        Builder setResolverFactoryByName(Map<String, StackTraceElementResolverFactory> resolverFactoryByName) {
            this.resolverFactoryByName = resolverFactoryByName;
            return this;
        }

        Builder setSubstitutor(StackTraceElementResolverStringSubstitutor substitutor) {
            this.substitutor = substitutor;
            return this;
        }

        Builder setJsonWriter(JsonWriter jsonWriter) {
            this.jsonWriter = jsonWriter;
            return this;
        }

        Builder setDefaults(JsonTemplateLayoutProperties defaults) {
            this.defaults = defaults;
            return this;
        }

        StackTraceElementResolverContext build() {
            this.validate();
            return new StackTraceElementResolverContext(this);
        }

        private void validate() {
            Objects.requireNonNull(this.resolverFactoryByName, "resolverFactoryByName");
            if (this.resolverFactoryByName.isEmpty()) {
                throw new IllegalArgumentException("empty resolverFactoryByName");
            }
            Objects.requireNonNull(this.substitutor, "substitutor");
            Objects.requireNonNull(this.jsonWriter, "jsonWriter");
            Objects.requireNonNull(this.defaults, "defaults");
        }
    }
}

