/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.composite.MergeStrategy;
import org.apache.logging.log4j.core.impl.CoreDefaultBundle;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.time.ClockFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.ConfigurableInstanceFactoryPostProcessor;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Ordered(value=2147482647)
@NullMarked
@ServiceProvider(value=ConfigurableInstanceFactoryPostProcessor.class, resolution="optional")
public class CoreInstanceFactoryPostProcessor
implements ConfigurableInstanceFactoryPostProcessor {
    public void postProcessFactory(ConfigurableInstanceFactory factory) {
        PropertyEnvironment env = (PropertyEnvironment)factory.getInstance(PropertyEnvironment.class);
        if (factory.hasBinding(Configuration.KEY)) {
            this.registerConfigurationServices(factory, env);
        } else if (factory.hasBinding(LoggerContext.KEY)) {
            this.registerLoggerContextSevices(factory, env);
        } else {
            this.registerGlobalServices(factory, env);
        }
        factory.registerBundles(new Object[]{ClockFactory.class, CoreDefaultBundle.class});
    }

    private void registerConfigurationServices(ConfigurableInstanceFactory factory, PropertyEnvironment env) {
        CoreProperties.LogEventProperties logEvent = (CoreProperties.LogEventProperties)env.getProperty(CoreProperties.LogEventProperties.class);
        this.registerIfPresent(factory, LogEventFactory.class, logEvent.factory());
        this.registerIfPresent(factory, ContextDataInjector.class, logEvent.contextData().injector());
        CoreProperties.StatusLoggerProperties statusLogger = (CoreProperties.StatusLoggerProperties)env.getProperty(CoreProperties.StatusLoggerProperties.class);
        factory.registerBinding(Constants.STATUS_LOGGER_LEVEL_KEY, statusLogger::level);
    }

    private void registerGlobalServices(ConfigurableInstanceFactory factory, PropertyEnvironment env) {
        CoreProperties.LoggerContextProperties loggerContext = (CoreProperties.LoggerContextProperties)env.getProperty(CoreProperties.LoggerContextProperties.class);
        this.registerIfPresent(factory, ContextSelector.class, loggerContext.selector());
        this.registerIfPresent(factory, ShutdownCallbackRegistry.class, loggerContext.shutdownCallbackRegistry());
    }

    private void registerLoggerContextSevices(ConfigurableInstanceFactory factory, PropertyEnvironment env) {
        CoreProperties.AuthenticationProperties auth = (CoreProperties.AuthenticationProperties)env.getProperty(CoreProperties.AuthenticationProperties.class);
        this.registerIfPresent(factory, AuthorizationProvider.class, auth.provider());
        CoreProperties.ConfigurationProperties configuration = (CoreProperties.ConfigurationProperties)env.getProperty(CoreProperties.ConfigurationProperties.class);
        this.registerIfPresent(factory, ConfigurationFactory.class, configuration.factory());
        this.registerIfPresent(factory, MergeStrategy.class, configuration.mergeStrategy());
        CoreProperties.MessageProperties message = (CoreProperties.MessageProperties)env.getProperty(CoreProperties.MessageProperties.class);
        this.registerIfPresent(factory, MessageFactory.class, message.factory());
    }

    private <T> void registerIfPresent(ConfigurableInstanceFactory instanceFactory, Class<T> serviceType, @Nullable Class<? extends T> serviceImplementation) {
        if (serviceImplementation != null) {
            instanceFactory.registerBinding(Key.forClass(serviceType), () -> instanceFactory.getInstance(serviceImplementation));
        }
    }
}

