/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.appender;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="Block", category="Core", elementType="appender", printObject=true)
public class BlockingAppender
extends AbstractAppender {
    public volatile boolean running = true;

    private BlockingAppender(String name) {
        super(name, null, null, false, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        while (this.running) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                this.running = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.running = false;
        this.setStopped();
        return true;
    }

    @PluginFactory
    public static BlockingAppender createAppender(@PluginAttribute(value="name") @Required(message="A name for the Appender must be specified") String name) {
        return new BlockingAppender(name);
    }
}

