/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shirorealm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import org.apache.knox.gateway.ShiroMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.shiro.ShiroException;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.Initializable;
import org.ehcache.Cache;
import org.ehcache.StateTransitionException;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.impl.config.persistence.CacheManagerPersistenceConfiguration;
import org.ehcache.integrations.shiro.EhcacheShiro;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.XmlConfiguration;

public class KnoxCacheManager
implements CacheManager,
Initializable,
Destroyable {
    private static final ShiroMessages LOG = (ShiroMessages)MessagesFactory.get(ShiroMessages.class);
    private org.ehcache.CacheManager manager;
    private String cacheManagerConfigFile = "classpath:org/ehcache/integrations/shiro/ehcache.xml";
    private boolean cacheManagerImplicitlyCreated;
    private XmlConfiguration cacheConfiguration;
    private static final String DEFAULT_FOLDER_NAME = "ehcache-shiro";

    public org.ehcache.CacheManager getCacheManager() {
        return this.manager;
    }

    public void setCacheManager(org.ehcache.CacheManager cacheManager) {
        try {
            this.destroy();
        }
        catch (Exception e) {
            LOG.errorClosingManagedCacheManager(e);
        }
        this.manager = cacheManager;
        this.cacheManagerImplicitlyCreated = false;
    }

    public String getCacheManagerConfigFile() {
        return this.cacheManagerConfigFile;
    }

    public void setCacheManagerConfigFile(String cacheManagerConfigFile) {
        this.cacheManagerConfigFile = cacheManagerConfigFile;
    }

    public <K, V> org.apache.shiro.cache.Cache<K, V> getCache(String name) throws CacheException {
        LOG.acquireEhcacheShiro(name);
        try {
            Cache<Object, Object> cache = this.ensureCacheManager().getCache(name, Object.class, Object.class);
            if (cache == null) {
                LOG.noCacheFound(name);
                cache = this.createCache(name);
                LOG.ehcacheShiroAdded(name);
            } else {
                LOG.usingExistingEhcacheShiro(name);
            }
            return new EhcacheShiro(cache);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private synchronized Cache<Object, Object> createCache(String name) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Cache cache = this.ensureCacheManager().getCache(name, Object.class, Object.class);
        if (cache == null) {
            XmlConfiguration xmlConfiguration = this.getConfiguration();
            CacheConfigurationBuilder configurationBuilder = xmlConfiguration.newCacheConfigurationBuilderFromTemplate("defaultCacheConfiguration", Object.class, Object.class);
            CacheConfiguration cacheConfiguration = configurationBuilder.build();
            cache = this.ensureCacheManager().createCache(name, cacheConfiguration);
        }
        return cache;
    }

    private org.ehcache.CacheManager ensureCacheManager() throws MalformedURLException {
        if (this.manager == null) {
            XmlConfiguration xmlConfiguration = this.getConfiguration();
            this.manager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfiguration);
            try {
                this.manager.init();
            }
            catch (StateTransitionException e) {
                if (KnoxCacheManager.containsOverlappingFileLockException(e)) {
                    LOG.resolvePersistenceDirLockError(e.getMessage());
                    this.resolveLockConflict(xmlConfiguration);
                    if (this.manager.getStatus() != Status.UNINITIALIZED) {
                        this.manager.close();
                    }
                    this.manager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfiguration);
                    this.manager.init();
                }
                throw e;
            }
            this.cacheManagerImplicitlyCreated = true;
        }
        return this.manager;
    }

    private static boolean containsOverlappingFileLockException(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof OverlappingFileLockException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private void resolveLockConflict(XmlConfiguration xmlConfiguration) {
        Optional<ServiceCreationConfiguration> serviceConfig = xmlConfiguration.getServiceCreationConfigurations().stream().filter(service -> service instanceof CacheManagerPersistenceConfiguration).findFirst();
        if (serviceConfig.isPresent()) {
            CacheManagerPersistenceConfiguration cachePersistenceConfig = (CacheManagerPersistenceConfiguration)serviceConfig.get();
            String path = cachePersistenceConfig.getRootDirectory().getPath();
            xmlConfiguration.getServiceCreationConfigurations().remove(cachePersistenceConfig);
            String newFolder = DEFAULT_FOLDER_NAME + UUID.randomUUID().toString().substring(0, 4);
            String newRootDirectory = Paths.get(path, new String[0]).getParent().resolve(newFolder).toAbsolutePath().toString();
            xmlConfiguration.getServiceCreationConfigurations().add(new CacheManagerPersistenceConfiguration(new File(newRootDirectory)));
        }
    }

    private URL getResource() throws MalformedURLException {
        if (this.cacheManagerConfigFile.startsWith("file:")) {
            return new URL(this.cacheManagerConfigFile);
        }
        String URL2 = ResourceUtils.hasResourcePrefix((String)this.cacheManagerConfigFile) ? KnoxCacheManager.stripPrefix(this.cacheManagerConfigFile) : this.cacheManagerConfigFile;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader.getResource(URL2);
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(58) + 1);
    }

    private XmlConfiguration getConfiguration() throws MalformedURLException {
        if (this.cacheConfiguration == null) {
            this.cacheConfiguration = new XmlConfiguration(this.getResource());
        }
        return this.cacheConfiguration;
    }

    public void destroy() {
        if (this.cacheManagerImplicitlyCreated && this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    public void init() throws ShiroException {
        try {
            this.ensureCacheManager();
        }
        catch (MalformedURLException e) {
            throw new ShiroException((Throwable)e);
        }
    }
}

