/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.model.ApiRoleConfigList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;

class ClouderaManagerServiceDiscoveryRepository {
    private static final ClouderaManagerServiceDiscoveryRepository INSTANCE = new ClouderaManagerServiceDiscoveryRepository();
    private final Map<RepositoryKey, Cache<ApiService, ServiceDetails>> repository = new ConcurrentHashMap<RepositoryKey, Cache<ApiService, ServiceDetails>>();
    private long cacheEntryTTL = 600L;

    private ClouderaManagerServiceDiscoveryRepository() {
    }

    static ClouderaManagerServiceDiscoveryRepository getInstance() {
        return INSTANCE;
    }

    void setCacheEntryTTL(long cacheEntryTTL) {
        this.cacheEntryTTL = cacheEntryTTL;
    }

    void clear() {
        this.repository.clear();
    }

    void addService(ServiceDiscoveryConfig serviceDiscoveryConfig, ApiService service) {
        this.getClusterServices(serviceDiscoveryConfig).put((Object)service, (Object)new ServiceDetails());
    }

    List<ApiService> getServices(ServiceDiscoveryConfig serviceDiscoveryConfig) {
        Cache<ApiService, ServiceDetails> clusterServices = this.getClusterServices(serviceDiscoveryConfig);
        return clusterServices.asMap().entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (ApiService)entry.getKey()).collect(Collectors.toList());
    }

    private Cache<ApiService, ServiceDetails> getClusterServices(ServiceDiscoveryConfig serviceDiscoveryConfig) {
        return this.repository.computeIfAbsent(RepositoryKey.of(serviceDiscoveryConfig), k -> Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.cacheEntryTTL)).build());
    }

    void addServiceConfig(ServiceDiscoveryConfig serviceDiscoveryConfig, ApiService service, ApiServiceConfig serviceConfig) {
        ServiceDetails serviceDetails = this.getServiceDetails(serviceDiscoveryConfig, service);
        if (serviceDetails != null) {
            serviceDetails.setServiceConfig(serviceConfig);
        }
    }

    private ServiceDetails getServiceDetails(ServiceDiscoveryConfig serviceDiscoveryConfig, ApiService service) {
        return (ServiceDetails)this.getClusterServices(serviceDiscoveryConfig).getIfPresent((Object)service);
    }

    ApiServiceConfig getServiceConfig(ServiceDiscoveryConfig serviceDiscoveryConfig, ApiService service) {
        ServiceDetails serviceDetails = this.getServiceDetails(serviceDiscoveryConfig, service);
        return serviceDetails == null ? null : serviceDetails.getServiceConfig();
    }

    void setServiceRoleConfigs(ServiceDiscoveryConfig serviceDiscoveryConfig, ApiService service, ApiRoleConfigList roleConfigs) {
        ServiceDetails serviceDetails = this.getServiceDetails(serviceDiscoveryConfig, service);
        if (serviceDetails != null) {
            serviceDetails.setAllServiceRoleConfigs(roleConfigs);
        }
    }

    ApiRoleConfigList getServiceRoleConfigs(ServiceDiscoveryConfig serviceDiscoveryConfig, ApiService service) {
        ServiceDetails serviceDetails = this.getServiceDetails(serviceDiscoveryConfig, service);
        return serviceDetails == null ? null : serviceDetails.getAllServiceRoleConfigs();
    }

    private static class ServiceDetails {
        private ApiServiceConfig serviceConfig;
        private ApiRoleConfigList roleConfigList;

        private ServiceDetails() {
        }

        public ApiServiceConfig getServiceConfig() {
            return this.serviceConfig;
        }

        public void setServiceConfig(ApiServiceConfig serviceConfig) {
            this.serviceConfig = serviceConfig;
        }

        public ApiRoleConfigList getAllServiceRoleConfigs() {
            return this.roleConfigList;
        }

        public void setAllServiceRoleConfigs(ApiRoleConfigList roleConfigList) {
            this.roleConfigList = roleConfigList;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static final class RepositoryKey {
        private final String address;
        private final String clusterName;

        private RepositoryKey(String address, String clusterName) {
            this.address = address;
            this.clusterName = clusterName;
        }

        static RepositoryKey of(ServiceDiscoveryConfig serviceDiscoveryConfig) {
            return new RepositoryKey(serviceDiscoveryConfig.getAddress(), serviceDiscoveryConfig.getCluster());
        }

        String getAddress() {
            return this.address;
        }

        String getClusterName() {
            return this.clusterName;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

