/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonIndexCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private boolean beforeFirst = true;
    private boolean afterLast;
    private boolean onSingleton;
    private final IndexEntry<V, String> singleton;

    public SingletonIndexCursor(PartitionTxn partitionTxn, IndexEntry<V, String> singleton) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating SingletonIndexCursor {}", (Object)this);
        }
        this.singleton = singleton;
        this.partitionTxn = partitionTxn;
    }

    @Override
    protected String getUnsupportedMessage() {
        return "Unsupported operation";
    }

    @Override
    public boolean available() {
        return this.onSingleton;
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.beforeFirst = true;
        this.afterLast = false;
        this.onSingleton = false;
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        this.beforeFirst = false;
        this.afterLast = true;
        this.onSingleton = false;
    }

    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed();
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed();
        this.beforeFirst = false;
        this.onSingleton = true;
        this.afterLast = false;
        return true;
    }

    public boolean isFirst() {
        return this.onSingleton;
    }

    public boolean isLast() {
        return this.onSingleton;
    }

    public boolean isAfterLast() {
        return this.afterLast;
    }

    public boolean isBeforeFirst() {
        return this.beforeFirst;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.beforeFirst) {
            return false;
        }
        if (this.afterLast) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        this.beforeFirst = true;
        this.onSingleton = false;
        this.afterLast = false;
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.onSingleton = true;
            this.afterLast = false;
            return true;
        }
        if (this.afterLast) {
            return false;
        }
        this.beforeFirst = false;
        this.onSingleton = false;
        this.afterLast = true;
        return false;
    }

    public IndexEntry<V, String> get() throws CursorException {
        this.checkNotClosed();
        if (this.onSingleton) {
            return this.singleton;
        }
        if (this.beforeFirst) {
            throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_705, (Object[])new Object[0]));
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_706, (Object[])new Object[0]));
    }

    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SingletonIndexCursor {}", (Object)this);
        }
        super.close();
    }

    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing SingletonIndexCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

