/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.Executor;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.DestinationEndpoint;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.MessageSentCallback;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.SimpleJmsMessageListenerContainer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

@UriParams
public class JmsConfiguration
implements Cloneable {
    public static final String QUEUE_PREFIX = "queue:";
    public static final String TOPIC_PREFIX = "topic:";
    public static final String TEMP_QUEUE_PREFIX = "temp-queue:";
    public static final String TEMP_TOPIC_PREFIX = "temp-topic:";
    private static final Logger LOG = LoggerFactory.getLogger(JmsConfiguration.class);
    private JmsOperations jmsOperations;
    private ConnectionFactory templateConnectionFactory;
    private ConnectionFactory listenerConnectionFactory;
    @UriParam(description="The connection factory to be use. A connection factory must be configured either on the component or endpoint.")
    private ConnectionFactory connectionFactory;
    @UriParam(label="security", secret=true, description="Username to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.")
    private String username;
    @UriParam(label="security", secret=true, description="Password to use with the ConnectionFactory. You can also configure username/password directly on the ConnectionFactory.")
    private String password;
    private int acknowledgementMode = -1;
    @UriParam(defaultValue="AUTO_ACKNOWLEDGE", enums="SESSION_TRANSACTED,CLIENT_ACKNOWLEDGE,AUTO_ACKNOWLEDGE,DUPS_OK_ACKNOWLEDGE", label="consumer", description="The JMS acknowledgement name, which is one of: SESSION_TRANSACTED, CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE")
    private String acknowledgementModeName;
    @UriParam(label="advanced", description="A pluggable org.springframework.jms.support.destination.DestinationResolver that allows you to use your own resolver (for example, to lookup the real destination in a JNDI registry).")
    private DestinationResolver destinationResolver;
    @UriParam(label="advanced", description="Specifies the JMS Exception Listener that is to be notified of any underlying JMS exceptions.")
    private ExceptionListener exceptionListener;
    @UriParam(label="consumer,advanced", defaultValue="Default", description="The consumer type to use, which can be one of: Simple, Default, or Custom. The consumer type determines which Spring JMS listener to use. Default will use org.springframework.jms.listener.DefaultMessageListenerContainer, Simple will use org.springframework.jms.listener.SimpleMessageListenerContainer. When Custom is specified, the MessageListenerContainerFactory defined by the messageListenerContainerFactory option will determine what org.springframework.jms.listener.AbstractMessageListenerContainer to use.")
    private ConsumerType consumerType = ConsumerType.Default;
    @UriParam(label="advanced", description="Specifies a org.springframework.util.ErrorHandler to be invoked in case of any uncaught exceptions thrown while processing a Message. By default these exceptions will be logged at the WARN level, if no errorHandler has been configured. You can configure logging level and whether stack traces should be logged using errorHandlerLoggingLevel and errorHandlerLogStackTrace options. This makes it much easier to configure, than having to code a custom errorHandler.")
    private ErrorHandler errorHandler;
    @UriParam(defaultValue="WARN", label="consumer,logging", description="Allows to configure the default errorHandler logging level for logging uncaught exceptions.")
    private LoggingLevel errorHandlerLoggingLevel = LoggingLevel.WARN;
    @UriParam(defaultValue="true", label="consumer,logging", description="Allows to control whether stacktraces should be logged or not, by the default errorHandler.")
    private boolean errorHandlerLogStackTrace = true;
    @UriParam(label="consumer", defaultValue="true", description="Specifies whether the consumer container should auto-startup.")
    private boolean autoStartup = true;
    @UriParam(label="consumer,advanced", description="Whether the DefaultMessageListenerContainer used in the reply managers for request-reply messaging allow  the DefaultMessageListenerContainer.runningAllowed flag to quick stop in case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and org.apache.camel.CamelContext is currently being stopped. This quick stop ability is enabled by default in the regular JMS consumers but to enable for reply managers you must enable this flag.")
    private boolean allowReplyManagerQuickStop;
    @UriParam(label="consumer,advanced", description="Specifies whether the consumer accept messages while it is stopping. You may consider enabling this option, if you start and stop JMS routes at runtime, while there are still messages enqueued on the queue. If this option is false, and you stop the JMS route, then messages may be rejected, and the JMS broker would have to attempt redeliveries, which yet again may be rejected, and eventually the message may be moved at a dead letter queue on the JMS broker. To avoid this its recommended to enable this option.")
    private boolean acceptMessagesWhileStopping;
    @UriParam(description="Sets the JMS client ID to use. Note that this value, if specified, must be unique and can only be used by a single JMS connection instance. It is typically only required for durable topic subscriptions. If using Apache ActiveMQ you may prefer to use Virtual Topics instead.")
    private String clientId;
    @UriParam(description="The durable subscriber name for specifying durable topic subscriptions. The clientId option must be configured as well.")
    private String durableSubscriptionName;
    @UriParam(label="consumer,advanced", description="Specifies whether the listener session should be exposed when consuming messages.")
    private boolean exposeListenerSession = true;
    @UriParam(label="consumer,advanced", description="Allows you to specify a custom task executor for consuming messages.")
    private TaskExecutor taskExecutor;
    @UriParam(label="advanced", description="Specifies whether to inhibit the delivery of messages published by its own connection.")
    private boolean pubSubNoLocal;
    @UriParam(defaultValue="1", label="consumer", description="Specifies the default number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.")
    private int concurrentConsumers = 1;
    @UriParam(defaultValue="1", label="producer", description="Specifies the default number of concurrent consumers when doing request/reply over JMS. See also the maxMessagesPerTask option to control dynamic scaling up/down of threads.")
    private int replyToConcurrentConsumers = 1;
    @UriParam(defaultValue="-1", label="advanced", description="The number of messages per task. -1 is unlimited. If you use a range for concurrent consumers (eg min < max), then this option can be used to set a value to eg 100 to control how fast the consumers will shrink when less work is required.")
    private int maxMessagesPerTask = -1;
    @UriParam(label="consumer", description="Sets the cache level by ID for the underlying JMS resources. See cacheLevelName option for more details.")
    private int cacheLevel = -1;
    @UriParam(defaultValue="CACHE_AUTO", enums="CACHE_AUTO,CACHE_CONNECTION,CACHE_CONSUMER,CACHE_NONE,CACHE_SESSION", label="consumer", description="Sets the cache level by name for the underlying JMS resources. Possible values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER, CACHE_NONE, and CACHE_SESSION. The default setting is CACHE_AUTO. See the Spring documentation and Transactions Cache Levels for more information.")
    private String cacheLevelName;
    @UriParam(defaultValue="5000", label="advanced", javaType="java.time.Duration", description="Specifies the interval between recovery attempts, i.e. when a connection is being refreshed, in milliseconds. The default is 5000 ms, that is, 5 seconds.")
    private long recoveryInterval = 5000L;
    @UriParam(defaultValue="1000", label="advanced", javaType="java.time.Duration", description="The timeout for receiving messages (in milliseconds).")
    private long receiveTimeout = 1000L;
    @UriParam(defaultValue="20000", label="producer", javaType="java.time.Duration", description="The timeout for waiting for a reply when using the InOut Exchange Pattern (in milliseconds). The default is 20 seconds. You can include the header \"CamelJmsRequestTimeout\" to override this endpoint configured timeout value, and thus have per message individual timeout values. See also the requestTimeoutCheckerInterval option.")
    private long requestTimeout = 20000L;
    @UriParam(defaultValue="1000", label="advanced", javaType="java.time.Duration", description="Configures how often Camel should check for timed out Exchanges when doing request/reply over JMS. By default Camel checks once per second. But if you must react faster when a timeout occurs, then you can lower this interval, to check more frequently. The timeout is determined by the option requestTimeout.")
    private long requestTimeoutCheckerInterval = 1000L;
    @UriParam(defaultValue="1", label="advanced", description="Specifies the limit for idle executions of a receive task, not having received any message within its execution. If this limit is reached, the task will shut down and leave receiving to other executing tasks (in the case of dynamic scheduling; see the maxConcurrentConsumers setting). There is additional doc available from Spring.")
    private int idleTaskExecutionLimit = 1;
    @UriParam(defaultValue="1", label="advanced", description="Specify the limit for the number of consumers that are allowed to be idle at any given time.")
    private int idleConsumerLimit = 1;
    @UriParam(defaultValue="100", label="advanced", javaType="java.time.Duration", description="Interval in millis to sleep each time while waiting for provisional correlation id to be updated.")
    private long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime = 100L;
    @UriParam(defaultValue="50", label="advanced", description="Number of times to wait for provisional correlation id to be updated to the actual correlation id when doing request/reply over JMS and when the option useMessageIDAsCorrelationID is enabled.")
    private int waitForProvisionCorrelationToBeUpdatedCounter = 50;
    @UriParam(label="consumer", description="Specifies the maximum number of concurrent consumers when consuming from JMS (not for request/reply over JMS). See also the maxMessagesPerTask option to control dynamic scaling up/down of threads. When doing request/reply over JMS then the option replyToMaxConcurrentConsumers is used to control number of concurrent consumers on the reply message listener.")
    private int maxConcurrentConsumers;
    @UriParam(label="producer", description="Specifies the maximum number of concurrent consumers when using request/reply over JMS. See also the maxMessagesPerTask option to control dynamic scaling up/down of threads.")
    private int replyToMaxConcurrentConsumers;
    @UriParam(label="producer", defaultValue="1", description="Specifies the maximum number of concurrent consumers for continue routing when timeout occurred when using request/reply over JMS.")
    private int replyToOnTimeoutMaxConcurrentConsumers = 1;
    @UriParam(label="producer", defaultValue="false", description="Set if the deliveryMode, priority or timeToLive qualities of service should be used when sending messages. This option is based on Spring's JmsTemplate. The deliveryMode, priority and timeToLive options are applied to the current endpoint. This contrasts with the preserveMessageQos option, which operates at message granularity, reading QoS properties exclusively from the Camel In message headers.")
    private Boolean explicitQosEnabled;
    @UriParam(defaultValue="true", label="producer", description="Specifies whether persistent delivery is used by default.")
    private boolean deliveryPersistent = true;
    @UriParam(enums="1,2", label="producer", description="Specifies the delivery mode to be used. Possible values are those defined by javax.jms.DeliveryMode. NON_PERSISTENT = 1 and PERSISTENT = 2.")
    private Integer deliveryMode;
    @UriParam(defaultValue="true", label="consumer", description="Specifies whether to use persistent delivery by default for replies.")
    private boolean replyToDeliveryPersistent = true;
    @UriParam(label="consumer", description="Sets the JMS selector to use")
    private String selector;
    @UriParam(defaultValue="-1", label="producer", description="When sending messages, specifies the time-to-live of the message (in milliseconds).")
    private long timeToLive = -1L;
    @UriParam(label="advanced", description="To use a custom Spring org.springframework.jms.support.converter.MessageConverter so you can be in control how to map to/from a javax.jms.Message.")
    private MessageConverter messageConverter;
    @UriParam(defaultValue="true", label="advanced", description="Specifies whether Camel should auto map the received JMS message to a suited payload type, such as javax.jms.TextMessage to a String etc.")
    private boolean mapJmsMessage = true;
    @UriParam(defaultValue="true", label="advanced", description="When sending, specifies whether message IDs should be added. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the message ID set to null; if the provider ignores the hint, the message ID must be set to its normal unique value.")
    private boolean messageIdEnabled = true;
    @UriParam(defaultValue="true", label="advanced", description="Specifies whether timestamps should be enabled by default on sending messages. This is just an hint to the JMS broker. If the JMS provider accepts this hint, these messages must have the timestamp set to zero; if the provider ignores the hint the timestamp must be set to its normal value.")
    private boolean messageTimestampEnabled = true;
    @UriParam(defaultValue="4", enums="1,2,3,4,5,6,7,8,9", label="producer", description="Values greater than 1 specify the message priority when sending (where 0 is the lowest priority and 9 is the highest). The explicitQosEnabled option must also be enabled in order for this option to have any effect.")
    private int priority = 4;
    @UriParam(label="transaction", description="Specifies whether to use transacted mode")
    private boolean transacted;
    @UriParam(label="transaction", description="Specifies whether InOut operations (request reply) default to using transacted mode If this flag is set to true, then Spring JmsTemplate will have sessionTransacted set to true, and the acknowledgeMode as transacted on the JmsTemplate used for InOut operations. Note from Spring JMS: that within a JTA transaction, the parameters passed to createQueue, createTopic methods are not taken into account. Depending on the Java EE transaction context, the container makes its own decisions on these values. Analogously, these parameters are not taken into account within a locally managed transaction either, since Spring JMS operates on an existing JMS Session in this case. Setting this flag to true will use a short local JMS transaction when running outside of a managed transaction, and a synchronized local JMS transaction in case of a managed transaction (other than an XA transaction) being present. This has the effect of a local JMS transaction being managed alongside the main transaction (which might be a native JDBC transaction), with the JMS transaction committing right after the main transaction.")
    private boolean transactedInOut;
    @UriParam(defaultValue="true", label="transaction,advanced", description="If true, Camel will create a JmsTransactionManager, if there is no transactionManager injected when option transacted=true.")
    private boolean lazyCreateTransactionManager = true;
    @UriParam(label="transaction,advanced", description="The Spring transaction manager to use.")
    private PlatformTransactionManager transactionManager;
    @UriParam(label="transaction,advanced", description="The name of the transaction to use.")
    private String transactionName;
    @UriParam(defaultValue="-1", label="transaction,advanced", description="The timeout value of the transaction (in seconds), if using transacted mode.")
    private int transactionTimeout = -1;
    @UriParam(label="producer", description="Set to true, if you want to send message using the QoS settings specified on the message, instead of the QoS settings on the JMS endpoint. The following three headers are considered JMSPriority, JMSDeliveryMode, and JMSExpiration. You can provide all or only some of them. If not provided, Camel will fall back to use the values from the endpoint instead. So, when using this option, the headers override the values from the endpoint. The explicitQosEnabled option, by contrast, will only use options set on the endpoint, and not values from the message header.")
    private boolean preserveMessageQos;
    @UriParam(description="Specifies whether Camel ignores the JMSReplyTo header in messages. If true, Camel does not send a reply back to the destination specified in the JMSReplyTo header. You can use this option if you want Camel to consume from a route and you do not want Camel to automatically send back a reply message because another component in your code handles the reply message. You can also use this option if you want to use Camel as a proxy between different message brokers and you want to route message from one system to another.")
    private boolean disableReplyTo;
    @UriParam(label="consumer,advanced", defaultValue="Poison JMS message due to ${exception.message}", description="If eagerLoadingOfProperties is enabled and the JMS message payload (JMS body or JMS properties) is poison (cannot be read/mapped), then set this text as the message body instead so the message can be processed (the cause of the poison are already stored as exception on the Exchange). This can be turned off by setting eagerPoisonBody=false. See also the option eagerLoadingOfProperties.")
    private String eagerPoisonBody = "Poison JMS message payload: ${exception.message}";
    @UriParam(label="consumer,advanced", description="Enables eager loading of JMS properties and payload as soon as a message is loaded which generally is inefficient as the JMS properties may not be required but sometimes can catch early any issues with the underlying JMS provider and the use of JMS properties. See also the option eagerPoisonBody.")
    private boolean eagerLoadingOfProperties;
    @UriParam(label="producer,advanced", description="If true, Camel will always make a JMS message copy of the message when it is passed to the producer for sending. Copying the message is needed in some situations, such as when a replyToDestinationSelectorName is set (incidentally, Camel will set the alwaysCopyMessage option to true, if a replyToDestinationSelectorName is set)")
    private boolean alwaysCopyMessage;
    @UriParam(label="advanced", description="Specifies whether JMSMessageID should always be used as JMSCorrelationID for InOut messages.")
    private boolean useMessageIDAsCorrelationID;
    @UriParam(label="common", description="Provides an explicit ReplyTo destination (overrides any incoming value of Message.getJMSReplyTo() in consumer).")
    private String replyTo;
    @UriParam(label="producer,advanced", description="Sets the JMS Selector using the fixed name to be used so you can filter out your own replies from the others when using a shared queue (that is, if you are not using a temporary reply queue).")
    private String replyToDestinationSelectorName;
    @UriParam(label="producer", description="Provides an explicit ReplyTo destination in the JMS message, which overrides the setting of replyTo. It is useful if you want to forward the message to a remote Queue and receive the reply message from the ReplyTo destination.")
    private String replyToOverride;
    @UriParam(label="consumer,advanced", description="Whether a JMS consumer is allowed to send a reply message to the same destination that the consumer is using to consume from. This prevents an endless loop by consuming and sending back the same message to itself.")
    private boolean replyToSameDestinationAllowed;
    @UriParam(enums="Bytes,Map,Object,Stream,Text", description="Allows you to force the use of a specific javax.jms.Message implementation for sending JMS messages. Possible values are: Bytes, Map, Object, Stream, Text. By default, Camel would determine which JMS message type to use from the In body type. This option allows you to specify it.")
    private JmsMessageType jmsMessageType;
    @UriParam(label="advanced", enums="default,passthrough", description="Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides two implementations out of the box: default and passthrough. The default strategy will safely marshal dots and hyphens (. and -). The passthrough strategy leaves the key as is. Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation.")
    private JmsKeyFormatStrategy jmsKeyFormatStrategy;
    @UriParam(label="advanced", description="You can transfer the exchange over the wire instead of just the body and headers. The following fields are transferred: In body, Out body, Fault body, In headers, Out headers, Fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level. You must enable this option on both the producer and consumer side, so Camel knows the payloads is an Exchange and not a regular payload. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level,  which forces a strong coupling between the producers and consumer having to use compatible Camel versions!")
    private boolean transferExchange;
    @UriParam(label="advanced", description="Controls whether or not to include serialized headers. Applies only when {@code transferExchange} is {@code true}. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.")
    private boolean allowSerializedHeaders;
    @UriParam(label="advanced", description="If enabled and you are using Request Reply messaging (InOut) and an Exchange failed on the consumer side, then the caused Exception will be send back in response as a javax.jms.ObjectMessage. If the client is Camel, the returned Exception is rethrown. This allows you to use Camel JMS as a bridge in your routing - for example, using persistent queues to enable robust routing. Notice that if you also have transferExchange enabled, this option takes precedence. The caught exception is required to be serializable. The original Exception on the consumer side can be wrapped in an outer exception such as org.apache.camel.RuntimeCamelException when returned to the producer. Use this with caution as the data is using Java Object serialization and requires the received to be able to deserialize the data at Class level,  which forces a strong coupling between the producers and consumer!")
    private boolean transferException;
    @UriParam(description="Specifies whether to test the connection on startup. This ensures that when Camel starts that all the JMS consumers have a valid connection to the JMS broker. If a connection cannot be granted then Camel throws an exception on startup. This ensures that Camel is not started with failed connections. The JMS producers is tested as well.")
    private boolean testConnectionOnStartup;
    @UriParam(label="advanced", description="Whether to startup the JmsConsumer message listener asynchronously, when starting a route. For example if a JmsConsumer cannot get a connection to a remote JMS broker, then it may block while retrying and/or failover. This will cause Camel to block while starting routes. By setting this option to true, you will let routes startup, while the JmsConsumer connects to the JMS broker using a dedicated thread in asynchronous mode. If this option is used, then beware that if the connection could not be established, then an exception is logged at WARN level, and the consumer will not be able to receive messages; You can then restart the route to retry.")
    private boolean asyncStartListener;
    @UriParam(label="advanced", description="Whether to stop the JmsConsumer message listener asynchronously, when stopping a route.")
    private boolean asyncStopListener;
    @UriParam(label="producer,advanced", description="When using mapJmsMessage=false Camel will create a new JMS message to send to a new JMS destination if you touch the headers (get or set) during the route. Set this option to true to force Camel to send the original JMS message that was received.")
    private boolean forceSendOriginalMessage;
    @UriParam(label="producer,advanced", description="Use this option to force disabling time to live. For example when you do request/reply over JMS, then Camel will by default use the requestTimeout value as time to live on the message being sent. The problem is that the sender and receiver systems have to have their clocks synchronized, so they are in sync. This is not always so easy to archive. So you can use disableTimeToLive=true to not set a time to live value on the sent message. Then the message will not expire on the receiver system. See below in section About time to live for more details.")
    private boolean disableTimeToLive;
    @UriParam(label="producer", description="Allows for explicitly specifying which kind of strategy to use for replyTo queues when doing request/reply over JMS. Possible values are: Temporary, Shared, or Exclusive. By default Camel will use temporary queues. However if replyTo has been configured, then Shared is used by default. This option allows you to use exclusive queues instead of shared ones. See Camel JMS documentation for more details, and especially the notes about the implications if running in a clustered environment, and the fact that Shared reply queues has lower performance than its alternatives Temporary and Exclusive.")
    private ReplyToType replyToType;
    @UriParam(label="consumer", description="Whether the JmsConsumer processes the Exchange asynchronously. If enabled then the JmsConsumer may pickup the next message from the JMS queue, while the previous message is being processed asynchronously (by the Asynchronous Routing Engine). This means that messages may be processed not 100% strictly in order. If disabled (as default) then the Exchange is fully processed before the JmsConsumer will pickup the next message from the JMS queue. Note if transacted has been enabled, then asyncConsumer=true does not run asynchronously, as transaction  must be executed synchronously (Camel 3.0 may support async transactions).")
    private boolean asyncConsumer;
    @UriParam(label="producer,advanced", enums="CACHE_AUTO,CACHE_CONNECTION,CACHE_CONSUMER,CACHE_NONE,CACHE_SESSION", description="Sets the cache level by name for the reply consumer when doing request/reply over JMS. This option only applies when using fixed reply queues (not temporary). Camel will by default use: CACHE_CONSUMER for exclusive or shared w/ replyToSelectorName. And CACHE_SESSION for shared without replyToSelectorName. Some JMS brokers such as IBM WebSphere may require to set the replyToCacheLevelName=CACHE_NONE to work. Note: If using temporary queues then CACHE_NONE is not allowed, and you must use a higher value such as CACHE_CONSUMER or CACHE_SESSION.")
    private String replyToCacheLevelName;
    @UriParam(defaultValue="true", label="producer,advanced", description="Whether to allow sending messages with no body. If this option is false and the message body is null, then an JMSException is thrown.")
    private boolean allowNullBody = true;
    @UriParam(label="advanced", description="Registry ID of the MessageListenerContainerFactory used to determine what org.springframework.jms.listener.AbstractMessageListenerContainer to use to consume messages. Setting this will automatically set consumerType to Custom.")
    private MessageListenerContainerFactory messageListenerContainerFactory;
    @UriParam(label="producer,advanced", description="Only applicable when sending to JMS destination using InOnly (eg fire and forget). Enabling this option will enrich the Camel Exchange with the actual JMSMessageID that was used by the JMS client when the message was sent to the JMS destination.")
    private boolean includeSentJMSMessageID;
    @UriParam(label="consumer,advanced", description="Specifies what default TaskExecutor type to use in the DefaultMessageListenerContainer, for both consumer endpoints and the ReplyTo consumer of producer endpoints. Possible values: SimpleAsync (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's ThreadPoolTaskExecutor with optimal values - cached threadpool-like). If not set, it defaults to the previous behaviour, which uses a cached thread pool for consumer endpoints and SimpleAsync for reply consumers. The use of ThreadPool is recommended to reduce thread trash in elastic configurations with dynamically increasing and decreasing concurrent consumers.")
    private DefaultTaskExecutorType defaultTaskExecutorType;
    @UriParam(label="advanced", description="Whether to include all JMSXxxx properties when mapping from JMS to Camel Message. Setting this to true will include properties such as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy then this option does not apply.")
    private boolean includeAllJMSXProperties;
    @UriParam(label="advanced", description="To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of javax.jms.Message objects when Camel is sending a JMS message.")
    private MessageCreatedStrategy messageCreatedStrategy;
    @UriParam(label="producer,advanced", description="When using InOut exchange pattern use this JMS property instead of JMSCorrelationID JMS property to correlate messages. If set messages will be correlated solely on the value of this property JMSCorrelationID property will be ignored and not set by Camel.")
    private String correlationProperty;
    @UriParam(label="producer,advanced", description="This option is used to allow additional headers which may have values that are invalid according to JMS specification. For example some message systems such as WMQ do this with header names using prefix JMS_IBM_MQMD_ containing values with byte array or other invalid types. You can specify multiple header names separated by comma, and use * as suffix for wildcard matching.")
    private String allowAdditionalHeaders;
    @UriParam(label="producer", description="Sets whether JMS date properties should be formatted according to the ISO 8601 standard.")
    private boolean formatDateHeadersToIso8601;
    @UriParam(defaultValue="true", label="advanced", description="Whether optimizing for Apache Artemis streaming mode.")
    private boolean artemisStreamingEnabled = true;
    @UriParam(label="consumer", description="Set the name of a subscription to create. To be applied in case of a topic (pub-sub domain) with a shared or durable subscription. The subscription name needs to be unique within this client's JMS client id. Default is the class name of the specified message listener. Note: Only 1 concurrent consumer (which is the default of this message listener container) is allowed for each subscription, except for a shared subscription (which requires JMS 2.0).")
    private String subscriptionName;
    @UriParam(label="consumer", description="Set whether to make the subscription durable. The durable subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a durable subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well.")
    private boolean subscriptionDurable;
    @UriParam(label="consumer", description="Set whether to make the subscription shared. The shared subscription name to be used can be specified through the subscriptionName property. Default is false. Set this to true to register a shared subscription, typically in combination with a subscriptionName value (unless your message listener class name is good enough as subscription name). Note that shared subscriptions may also be durable, so this flag can (and often will) be combined with subscriptionDurable as well. Only makes sense when listening to a topic (pub-sub domain), therefore this method switches the pubSubDomain flag as well. Requires a JMS 2.0 compatible message broker.")
    private boolean subscriptionShared;
    @UriParam(label="producer,advanced", description="Sets whether StreamMessage type is enabled or not. Message payloads of streaming kind such as files, InputStream, etc will either by sent as BytesMessage or StreamMessage. This option controls which kind will be used. By default BytesMessage is used which enforces the entire message payload to be read into memory. By enabling this option the message payload is read into memory in chunks and each chunk is then written to the StreamMessage until no more data.")
    private boolean streamMessageTypeEnabled;
    @UriParam(defaultValue="-1", label="producer", description="Sets delivery delay to use for send calls for JMS. This option requires JMS 2.0 compliant broker.")
    private long deliveryDelay = -1L;

    public JmsConfiguration() {
    }

    public JmsConfiguration(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsConfiguration copy() {
        try {
            return (JmsConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public JmsOperations createInOutTemplate(JmsEndpoint endpoint, boolean pubSubDomain, String destination, long requestTimeout) {
        JmsOperations answer = this.createInOnlyTemplate(endpoint, pubSubDomain, destination);
        if (answer instanceof JmsTemplate && requestTimeout > 0L) {
            long ttl;
            JmsTemplate jmsTemplate = (JmsTemplate)answer;
            jmsTemplate.setExplicitQosEnabled(true);
            long l = ttl = this.timeToLive > 0L ? this.timeToLive : requestTimeout;
            if (!this.isDisableTimeToLive()) {
                jmsTemplate.setTimeToLive(ttl);
            }
            jmsTemplate.setSessionTransacted(this.transactedInOut);
            if (this.transactedInOut) {
                jmsTemplate.setSessionAcknowledgeMode(0);
            } else if (this.acknowledgementMode >= 0) {
                jmsTemplate.setSessionAcknowledgeMode(this.acknowledgementMode);
            } else if (this.acknowledgementModeName != null) {
                jmsTemplate.setSessionAcknowledgeModeName(this.acknowledgementModeName);
            } else {
                jmsTemplate.setSessionAcknowledgeMode(1);
            }
        }
        return answer;
    }

    public JmsOperations createInOnlyTemplate(JmsEndpoint endpoint, boolean pubSubDomain, String destination) {
        if (this.jmsOperations != null) {
            return this.jmsOperations;
        }
        ConnectionFactory factory = this.getOrCreateTemplateConnectionFactory();
        CamelJmsTemplate template = new CamelJmsTemplate(this, factory);
        template.setPubSubDomain(pubSubDomain);
        if (this.destinationResolver != null) {
            template.setDestinationResolver(this.destinationResolver);
            if (endpoint instanceof DestinationEndpoint) {
                LOG.debug("You are overloading the destinationResolver property on a DestinationEndpoint; are you sure you want to do that?");
            }
        } else if (endpoint instanceof DestinationEndpoint) {
            DestinationEndpoint destinationEndpoint = (DestinationEndpoint)((Object)endpoint);
            template.setDestinationResolver(JmsConfiguration.createDestinationResolver(destinationEndpoint));
        }
        template.setDefaultDestinationName(destination);
        template.setExplicitQosEnabled(this.isExplicitQosEnabled());
        if (this.deliveryMode != null) {
            template.setDeliveryMode(this.deliveryMode);
        } else {
            template.setDeliveryPersistent(this.deliveryPersistent);
        }
        if (this.messageConverter != null) {
            template.setMessageConverter(this.messageConverter);
        }
        template.setMessageIdEnabled(this.messageIdEnabled);
        template.setMessageTimestampEnabled(this.messageTimestampEnabled);
        if (this.priority >= 0) {
            template.setPriority(this.priority);
        }
        template.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.timeToLive >= 0L && !this.isDisableTimeToLive()) {
            template.setTimeToLive(this.timeToLive);
        }
        template.setSessionTransacted(this.transacted);
        if (this.transacted) {
            template.setSessionAcknowledgeMode(0);
        } else if (this.acknowledgementMode >= 0) {
            template.setSessionAcknowledgeMode(this.acknowledgementMode);
        } else if (this.acknowledgementModeName != null) {
            template.setSessionAcknowledgeModeName(this.acknowledgementModeName);
        }
        template.setDeliveryDelay(this.deliveryDelay);
        return template;
    }

    public AbstractMessageListenerContainer createMessageListenerContainer(JmsEndpoint endpoint) throws Exception {
        AbstractMessageListenerContainer container = this.chooseMessageListenerContainerImplementation(endpoint);
        this.configureMessageListenerContainer(container, endpoint);
        return container;
    }

    public AbstractMessageListenerContainer chooseMessageListenerContainerImplementation(JmsEndpoint endpoint) {
        switch (this.consumerType) {
            case Simple: {
                return new SimpleJmsMessageListenerContainer(endpoint);
            }
            case Default: {
                return new DefaultJmsMessageListenerContainer(endpoint);
            }
            case Custom: {
                return this.getCustomMessageListenerContainer(endpoint);
            }
        }
        throw new IllegalArgumentException("Unknown consumer type: " + (Object)((Object)this.consumerType));
    }

    private AbstractMessageListenerContainer getCustomMessageListenerContainer(JmsEndpoint endpoint) {
        if (this.messageListenerContainerFactory != null) {
            return this.messageListenerContainerFactory.createMessageListenerContainer(endpoint);
        }
        return null;
    }

    public ConsumerType getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.consumerType = consumerType;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public ConnectionFactory getOrCreateConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionFactory getListenerConnectionFactory() {
        return this.listenerConnectionFactory;
    }

    public ConnectionFactory getOrCreateListenerConnectionFactory() {
        if (this.listenerConnectionFactory == null) {
            this.listenerConnectionFactory = this.createListenerConnectionFactory();
        }
        return this.listenerConnectionFactory;
    }

    public void setListenerConnectionFactory(ConnectionFactory listenerConnectionFactory) {
        this.listenerConnectionFactory = listenerConnectionFactory;
    }

    public ConnectionFactory getTemplateConnectionFactory() {
        return this.templateConnectionFactory;
    }

    public ConnectionFactory getOrCreateTemplateConnectionFactory() {
        if (this.templateConnectionFactory == null) {
            this.templateConnectionFactory = this.createTemplateConnectionFactory();
        }
        return this.templateConnectionFactory;
    }

    public void setTemplateConnectionFactory(ConnectionFactory templateConnectionFactory) {
        this.templateConnectionFactory = templateConnectionFactory;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAcceptMessagesWhileStopping() {
        return this.acceptMessagesWhileStopping;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public boolean isAllowReplyManagerQuickStop() {
        return this.allowReplyManagerQuickStop;
    }

    public void setAllowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
        this.allowReplyManagerQuickStop = allowReplyManagerQuickStop;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String consumerClientId) {
        this.clientId = consumerClientId;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return this.errorHandlerLoggingLevel;
    }

    public void setErrorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
        this.errorHandlerLoggingLevel = errorHandlerLoggingLevel;
    }

    public boolean isErrorHandlerLogStackTrace() {
        return this.errorHandlerLogStackTrace;
    }

    public void setErrorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
        this.errorHandlerLogStackTrace = errorHandlerLogStackTrace;
    }

    public String getAcknowledgementModeName() {
        return this.acknowledgementModeName;
    }

    public void setAcknowledgementModeName(String consumerAcknowledgementMode) {
        this.acknowledgementModeName = consumerAcknowledgementMode;
        this.acknowledgementMode = -1;
    }

    public boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getReplyToConcurrentConsumers() {
        return this.replyToConcurrentConsumers;
    }

    public void setReplyToConcurrentConsumers(int replyToConcurrentConsumers) {
        this.replyToConcurrentConsumers = replyToConcurrentConsumers;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getCacheLevelName() {
        return this.cacheLevelName;
    }

    public void setCacheLevelName(String cacheName) {
        this.cacheLevelName = cacheName;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public PlatformTransactionManager getOrCreateTransactionManager() {
        if (this.transactionManager == null && this.isTransacted() && this.isLazyCreateTransactionManager()) {
            this.transactionManager = this.createTransactionManager();
        }
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public int getIdleConsumerLimit() {
        return this.idleConsumerLimit;
    }

    public void setIdleConsumerLimit(int idleConsumerLimit) {
        this.idleConsumerLimit = idleConsumerLimit;
    }

    public int getWaitForProvisionCorrelationToBeUpdatedCounter() {
        return this.waitForProvisionCorrelationToBeUpdatedCounter;
    }

    public void setWaitForProvisionCorrelationToBeUpdatedCounter(int counter) {
        this.waitForProvisionCorrelationToBeUpdatedCounter = counter;
    }

    public long getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime() {
        return this.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime;
    }

    public void setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long sleepingTime) {
        this.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime = sleepingTime;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getReplyToMaxConcurrentConsumers() {
        return this.replyToMaxConcurrentConsumers;
    }

    public void setReplyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
        this.replyToMaxConcurrentConsumers = replyToMaxConcurrentConsumers;
    }

    public int getReplyToOnTimeoutMaxConcurrentConsumers() {
        return this.replyToOnTimeoutMaxConcurrentConsumers;
    }

    public void setReplyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
        this.replyToOnTimeoutMaxConcurrentConsumers = replyToOnTimeoutMaxConcurrentConsumers;
    }

    public boolean isExplicitQosEnabled() {
        return this.explicitQosEnabled != null ? this.explicitQosEnabled : false;
    }

    public Boolean getExplicitQosEnabled() {
        return this.explicitQosEnabled;
    }

    public void setExplicitQosEnabled(boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public boolean isDeliveryPersistent() {
        return this.deliveryPersistent;
    }

    public void setDeliveryPersistent(boolean deliveryPersistent) {
        this.deliveryPersistent = deliveryPersistent;
        this.configuredQoS();
    }

    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
        this.configuredQoS();
    }

    public boolean isReplyToDeliveryPersistent() {
        return this.replyToDeliveryPersistent;
    }

    public void setReplyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
        this.replyToDeliveryPersistent = replyToDeliveryPersistent;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
        this.configuredQoS();
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public boolean isMapJmsMessage() {
        return this.mapJmsMessage;
    }

    public void setMapJmsMessage(boolean mapJmsMessage) {
        this.mapJmsMessage = mapJmsMessage;
    }

    public boolean isMessageIdEnabled() {
        return this.messageIdEnabled;
    }

    public void setMessageIdEnabled(boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public boolean isMessageTimestampEnabled() {
        return this.messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.configuredQoS();
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int consumerAcknowledgementMode) {
        this.acknowledgementMode = consumerAcknowledgementMode;
        this.acknowledgementModeName = null;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isTransactedInOut() {
        return this.transactedInOut;
    }

    public void setTransactedInOut(boolean transactedInOut) {
        this.transactedInOut = transactedInOut;
    }

    public boolean isLazyCreateTransactionManager() {
        return this.lazyCreateTransactionManager;
    }

    public void setLazyCreateTransactionManager(boolean lazyCreating) {
        this.lazyCreateTransactionManager = lazyCreating;
    }

    public String getEagerPoisonBody() {
        return this.eagerPoisonBody;
    }

    public void setEagerPoisonBody(String eagerPoisonBody) {
        this.eagerPoisonBody = eagerPoisonBody;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public void setPreserveMessageQos(boolean preserveMessageQos) {
        this.preserveMessageQos = preserveMessageQos;
    }

    public JmsOperations getJmsOperations() {
        return this.jmsOperations;
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.jmsOperations = jmsOperations;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public static DestinationResolver createDestinationResolver(DestinationEndpoint destinationEndpoint) {
        return (session, destinationName, pubSubDomain) -> destinationEndpoint.getJmsDestination(session);
    }

    protected void configureMessageListenerContainer(AbstractMessageListenerContainer container, JmsEndpoint endpoint) throws Exception {
        DefaultMessageListenerContainer listenerContainer;
        container.setConnectionFactory(this.getOrCreateListenerConnectionFactory());
        if (endpoint instanceof DestinationEndpoint) {
            container.setDestinationResolver(JmsConfiguration.createDestinationResolver((DestinationEndpoint)((Object)endpoint)));
        } else if (this.destinationResolver != null) {
            container.setDestinationResolver(this.destinationResolver);
        }
        container.setAutoStartup(this.autoStartup);
        if (this.durableSubscriptionName != null) {
            container.setDurableSubscriptionName(this.durableSubscriptionName);
            container.setSubscriptionDurable(true);
        }
        if (this.clientId != null) {
            container.setClientId(this.clientId);
        }
        if (this.exceptionListener != null) {
            container.setExceptionListener(this.exceptionListener);
        }
        if (this.errorHandler != null) {
            container.setErrorHandler(this.errorHandler);
        } else {
            DefaultSpringErrorHandler handler = new DefaultSpringErrorHandler(endpoint.getCamelContext(), EndpointMessageListener.class, this.getErrorHandlerLoggingLevel(), this.isErrorHandlerLogStackTrace());
            container.setErrorHandler((ErrorHandler)handler);
        }
        container.setAcceptMessagesWhileStopping(this.acceptMessagesWhileStopping);
        container.setExposeListenerSession(this.exposeListenerSession);
        container.setSessionTransacted(this.transacted);
        if (this.transacted) {
            container.setSessionAcknowledgeMode(0);
        } else if (this.acknowledgementMode >= 0) {
            container.setSessionAcknowledgeMode(this.acknowledgementMode);
        } else if (this.acknowledgementModeName != null) {
            container.setSessionAcknowledgeModeName(this.acknowledgementModeName);
        }
        if (endpoint.getSelector() != null && endpoint.getSelector().length() != 0) {
            container.setMessageSelector(endpoint.getSelector());
        }
        if (container instanceof DefaultMessageListenerContainer) {
            listenerContainer = (DefaultMessageListenerContainer)container;
            this.configureDefaultMessageListenerContainer(endpoint, listenerContainer);
        } else if (container instanceof SimpleMessageListenerContainer) {
            listenerContainer = (SimpleMessageListenerContainer)container;
            this.configureSimpleMessageListenerContainer((SimpleMessageListenerContainer)listenerContainer);
        }
    }

    private void configureSimpleMessageListenerContainer(SimpleMessageListenerContainer listenerContainer) {
        if (this.maxConcurrentConsumers > 0) {
            if (this.maxConcurrentConsumers < this.concurrentConsumers) {
                throw new IllegalArgumentException("Property maxConcurrentConsumers: " + this.maxConcurrentConsumers + " must be higher than concurrentConsumers: " + this.concurrentConsumers);
            }
            listenerContainer.setConcurrency(this.concurrentConsumers + "-" + this.maxConcurrentConsumers);
        } else if (this.concurrentConsumers >= 0) {
            listenerContainer.setConcurrentConsumers(this.concurrentConsumers);
        }
        listenerContainer.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.taskExecutor != null) {
            listenerContainer.setTaskExecutor((Executor)this.taskExecutor);
        }
    }

    private void configureDefaultMessageListenerContainer(JmsEndpoint endpoint, DefaultMessageListenerContainer container) {
        PlatformTransactionManager tm;
        if (this.concurrentConsumers >= 0) {
            container.setConcurrentConsumers(this.concurrentConsumers);
        }
        if (this.cacheLevel >= 0) {
            container.setCacheLevel(this.cacheLevel);
        } else if (this.cacheLevelName != null) {
            container.setCacheLevelName(this.cacheLevelName);
        } else {
            container.setCacheLevel(this.defaultCacheLevel(endpoint));
        }
        if (this.idleTaskExecutionLimit >= 0) {
            container.setIdleTaskExecutionLimit(this.idleTaskExecutionLimit);
        }
        if (this.idleConsumerLimit >= 0) {
            container.setIdleConsumerLimit(this.idleConsumerLimit);
        }
        if (this.maxConcurrentConsumers > 0) {
            if (this.maxConcurrentConsumers < this.concurrentConsumers) {
                throw new IllegalArgumentException("Property maxConcurrentConsumers: " + this.maxConcurrentConsumers + " must be higher than concurrentConsumers: " + this.concurrentConsumers);
            }
            container.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
        }
        if (this.maxMessagesPerTask >= 0) {
            container.setMaxMessagesPerTask(this.maxMessagesPerTask);
        }
        container.setPubSubNoLocal(this.pubSubNoLocal);
        if (this.receiveTimeout >= 0L) {
            container.setReceiveTimeout(this.receiveTimeout);
        }
        if (this.recoveryInterval >= 0L) {
            container.setRecoveryInterval(this.recoveryInterval);
        }
        if (this.taskExecutor != null) {
            container.setTaskExecutor((Executor)this.taskExecutor);
        }
        if ((tm = this.getOrCreateTransactionManager()) != null) {
            container.setTransactionManager(tm);
        } else if (this.transactionManager == null && this.transacted && !this.lazyCreateTransactionManager) {
            container.setSessionTransacted(true);
        }
        if (this.transactionName != null) {
            container.setTransactionName(this.transactionName);
        }
        if (this.transactionTimeout >= 0) {
            container.setTransactionTimeout(this.transactionTimeout);
        }
    }

    public void configureMessageListener(EndpointMessageListener listener) {
        JmsOperations operations;
        if (this.isDisableReplyTo()) {
            listener.setDisableReplyTo(true);
        }
        if (!"false".equals(this.eagerPoisonBody)) {
            listener.setEagerPoisonBody(this.eagerPoisonBody);
        }
        listener.setEagerLoadingOfProperties(this.eagerLoadingOfProperties);
        if (this.getReplyTo() != null) {
            listener.setReplyToDestination(this.getReplyTo());
        }
        if ((operations = listener.getTemplate()) instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)operations;
            template.setDeliveryPersistent(this.isReplyToDeliveryPersistent());
        }
    }

    protected int defaultCacheLevel(JmsEndpoint endpoint) {
        return 4;
    }

    protected ConnectionFactory createConnectionFactory() {
        ObjectHelper.notNull((Object)this.connectionFactory, (String)"connectionFactory");
        return null;
    }

    protected ConnectionFactory createListenerConnectionFactory() {
        return this.getOrCreateConnectionFactory();
    }

    protected ConnectionFactory createTemplateConnectionFactory() {
        return this.getOrCreateConnectionFactory();
    }

    protected PlatformTransactionManager createTransactionManager() {
        JmsTransactionManager answer = new JmsTransactionManager();
        answer.setConnectionFactory(this.getOrCreateConnectionFactory());
        return answer;
    }

    public boolean isPreserveMessageQos() {
        return this.preserveMessageQos;
    }

    protected void configuredQoS() {
        if (this.explicitQosEnabled == null) {
            this.explicitQosEnabled = true;
        }
    }

    public boolean isAlwaysCopyMessage() {
        return this.alwaysCopyMessage;
    }

    public void setAlwaysCopyMessage(boolean alwaysCopyMessage) {
        this.alwaysCopyMessage = alwaysCopyMessage;
    }

    public boolean isUseMessageIDAsCorrelationID() {
        return this.useMessageIDAsCorrelationID;
    }

    public void setUseMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
        this.useMessageIDAsCorrelationID = useMessageIDAsCorrelationID;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyToDestination) {
        this.replyTo = JmsMessageHelper.normalizeDestinationName(replyToDestination);
    }

    public String getReplyToDestinationSelectorName() {
        return this.replyToDestinationSelectorName;
    }

    public void setReplyToDestinationSelectorName(String replyToDestinationSelectorName) {
        this.replyToDestinationSelectorName = replyToDestinationSelectorName;
        if (replyToDestinationSelectorName != null) {
            this.setAlwaysCopyMessage(true);
        }
    }

    public String getReplyToOverride() {
        return this.replyToOverride;
    }

    public void setReplyToOverride(String replyToDestination) {
        this.replyToOverride = JmsMessageHelper.normalizeDestinationName(replyToDestination);
    }

    public boolean isReplyToSameDestinationAllowed() {
        return this.replyToSameDestinationAllowed;
    }

    public void setReplyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
        this.replyToSameDestinationAllowed = replyToSameDestinationAllowed;
    }

    public JmsMessageType getJmsMessageType() {
        return this.jmsMessageType;
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        if (jmsMessageType == JmsMessageType.Blob && !this.supportBlobMessage()) {
            throw new IllegalArgumentException("BlobMessage is not supported by this implementation");
        }
        this.jmsMessageType = jmsMessageType;
    }

    protected boolean supportBlobMessage() {
        return false;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        if (this.jmsKeyFormatStrategy == null) {
            this.jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
        }
        return this.jmsKeyFormatStrategy;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isAsyncStartListener() {
        return this.asyncStartListener;
    }

    public void setAsyncStartListener(boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public boolean isAsyncStopListener() {
        return this.asyncStopListener;
    }

    public void setAsyncStopListener(boolean asyncStopListener) {
        this.asyncStopListener = asyncStopListener;
    }

    public boolean isTestConnectionOnStartup() {
        return this.testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public void setForceSendOriginalMessage(boolean forceSendOriginalMessage) {
        this.forceSendOriginalMessage = forceSendOriginalMessage;
    }

    public boolean isForceSendOriginalMessage() {
        return this.forceSendOriginalMessage;
    }

    public boolean isDisableTimeToLive() {
        return this.disableTimeToLive;
    }

    public void setDisableTimeToLive(boolean disableTimeToLive) {
        this.disableTimeToLive = disableTimeToLive;
    }

    public ReplyToType getReplyToType() {
        return this.replyToType;
    }

    public void setReplyToType(ReplyToType replyToType) {
        this.replyToType = replyToType;
    }

    public boolean isAsyncConsumer() {
        return this.asyncConsumer;
    }

    public void setAsyncConsumer(boolean asyncConsumer) {
        this.asyncConsumer = asyncConsumer;
    }

    public void setReplyToCacheLevelName(String name) {
        this.replyToCacheLevelName = name;
    }

    public String getReplyToCacheLevelName() {
        return this.replyToCacheLevelName;
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public MessageListenerContainerFactory getMessageListenerContainerFactory() {
        return this.messageListenerContainerFactory;
    }

    public void setMessageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
        this.messageListenerContainerFactory = messageListenerContainerFactory;
    }

    public boolean isIncludeSentJMSMessageID() {
        return this.includeSentJMSMessageID;
    }

    public void setIncludeSentJMSMessageID(boolean includeSentJMSMessageID) {
        this.includeSentJMSMessageID = includeSentJMSMessageID;
    }

    public DefaultTaskExecutorType getDefaultTaskExecutorType() {
        return this.defaultTaskExecutorType;
    }

    public void setDefaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
        this.defaultTaskExecutorType = defaultTaskExecutorType;
    }

    public boolean isIncludeAllJMSXProperties() {
        return this.includeAllJMSXProperties;
    }

    public void setIncludeAllJMSXProperties(boolean includeAllJMSXProperties) {
        this.includeAllJMSXProperties = includeAllJMSXProperties;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void setCorrelationProperty(String correlationProperty) {
        this.correlationProperty = correlationProperty;
    }

    public String getCorrelationProperty() {
        return this.correlationProperty;
    }

    public String getAllowAdditionalHeaders() {
        return this.allowAdditionalHeaders;
    }

    public void setAllowAdditionalHeaders(String allowAdditionalHeaders) {
        this.allowAdditionalHeaders = allowAdditionalHeaders;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public boolean isSubscriptionShared() {
        return this.subscriptionShared;
    }

    public void setSubscriptionShared(boolean subscriptionShared) {
        this.subscriptionShared = subscriptionShared;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public boolean isStreamMessageTypeEnabled() {
        return this.streamMessageTypeEnabled;
    }

    public void setStreamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
        this.streamMessageTypeEnabled = streamMessageTypeEnabled;
    }

    public boolean isFormatDateHeadersToIso8601() {
        return this.formatDateHeadersToIso8601;
    }

    public void setFormatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
        this.formatDateHeadersToIso8601 = formatDateHeadersToIso8601;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public boolean isArtemisStreamingEnabled() {
        return this.artemisStreamingEnabled;
    }

    public void setArtemisStreamingEnabled(boolean artemisStreamingEnabled) {
        this.artemisStreamingEnabled = artemisStreamingEnabled;
    }

    public static class CamelJmsTemplate
    extends JmsTemplate {
        private JmsConfiguration config;

        public CamelJmsTemplate(JmsConfiguration config, ConnectionFactory connectionFactory) {
            super(connectionFactory);
            this.config = config;
        }

        public void send(String destinationName, MessageCreator messageCreator, MessageSentCallback callback) throws JmsException {
            this.execute(session -> {
                Destination destination = this.resolveDestinationName(session, destinationName);
                return this.doSendToDestination(destination, messageCreator, callback, session);
            }, false);
        }

        public void send(Destination destination, MessageCreator messageCreator, MessageSentCallback callback) throws JmsException {
            this.execute(session -> this.doSendToDestination(destination, messageCreator, callback, session), false);
        }

        public void send(String destinationName, MessageCreator messageCreator) throws JmsException {
            this.execute(session -> {
                Destination destination = this.resolveDestinationName(session, destinationName);
                return this.doSendToDestination(destination, messageCreator, null, session);
            }, false);
        }

        public void send(Destination destination, MessageCreator messageCreator) throws JmsException {
            this.execute(session -> this.doSendToDestination(destination, messageCreator, null, session), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object doSendToDestination(Destination destination, MessageCreator messageCreator, MessageSentCallback callback, Session session) throws JMSException {
            Assert.notNull((Object)messageCreator, (String)"MessageCreator must not be null");
            MessageProducer producer = this.createProducer(session, destination);
            try {
                Message message = messageCreator.createMessage(session);
                this.doSend(producer, message);
                if (message != null && callback != null) {
                    callback.sent(session, message, destination);
                }
                if (session.getTransacted() && this.isSessionLocallyTransacted(session)) {
                    JmsUtils.commitIfNecessary((Session)session);
                }
            }
            finally {
                JmsUtils.closeMessageProducer((MessageProducer)producer);
            }
            return null;
        }

        protected void doSend(MessageProducer producer, Message message) throws JMSException {
            if (this.config.isPreserveMessageQos()) {
                int deliveryMode;
                int priority;
                long ttl = message.getJMSExpiration();
                if (ttl != 0L && (ttl -= System.currentTimeMillis()) <= 0L) {
                    ttl = 1L;
                }
                if ((priority = message.getJMSPriority()) < 0 || priority > 9) {
                    priority = this.getPriority();
                }
                if (JmsMessageHelper.hasProperty(message, "CamelJmsDeliveryMode")) {
                    deliveryMode = message.getIntProperty("CamelJmsDeliveryMode");
                    JmsMessageHelper.removeJmsProperty(message, "CamelJmsDeliveryMode");
                } else {
                    deliveryMode = message.getJMSDeliveryMode();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending JMS message to: {} with message: {}", (Object)producer.getDestination(), (Object)message);
                }
                producer.send(message, deliveryMode, priority, ttl);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending JMS message to: {} with message: {}", (Object)producer.getDestination(), (Object)message);
                }
                super.doSend(producer, message);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sent JMS message to: {} with message: {}", (Object)producer.getDestination(), (Object)message);
                }
            }
        }
    }
}

