/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.tartarus.snowball.SnowballStemmer;

public class SnowballPorterFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "snowballPorter";
    public static final String PROTECTED_TOKENS = "protected";
    private final String language;
    private final String wordFiles;
    private Class<? extends SnowballStemmer> stemClass;
    private CharArraySet protectedWords = null;

    public SnowballPorterFilterFactory(Map<String, String> args) {
        super(args);
        this.language = this.get(args, "language", "English");
        this.wordFiles = this.get(args, PROTECTED_TOKENS);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public SnowballPorterFilterFactory() {
        throw SnowballPorterFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String className = "org.tartarus.snowball.ext." + this.language + "Stemmer";
        this.stemClass = loader.newInstance(className, SnowballStemmer.class).getClass();
        if (this.wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, this.wordFiles, false);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        SnowballStemmer program;
        try {
            program = this.stemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new RuntimeException("Error instantiating stemmer for language " + this.language + "from class " + this.stemClass, e2);
        }
        if (this.protectedWords != null) {
            input = new SetKeywordMarkerFilter(input, this.protectedWords);
        }
        return new SnowballFilter(input, program);
    }
}

