/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.property_functions.box;

import java.util.List;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.spatial.ConvertLatLonBox;
import org.apache.jena.geosparql.spatial.SearchEnvelope;
import org.apache.jena.geosparql.spatial.property_functions.GenericSpatialGeomPropertyFunction;
import org.apache.jena.geosparql.spatial.property_functions.SpatialArguments;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.FmtUtils;

public abstract class GenericSpatialBoxPropertyFunction
extends GenericSpatialGeomPropertyFunction {
    private static final int LAT_MIN_POS = 0;
    private static final int LON_MIN_POS = 1;
    private static final int LAT_MAX_POS = 2;
    private static final int LON_MAX_POS = 3;
    private static final int LIMIT_POS = 4;

    @Override
    protected SpatialArguments extractObjectArguments(Node predicate, PropFuncArg object, SRSInfo indexSRSInfo) {
        try {
            int limit;
            List<Node> objectArgs = object.getArgList();
            if (objectArgs.size() < 4) {
                throw new ExprEvalException(FmtUtils.stringForNode(predicate) + ": Minimum of 4 arguments.");
            }
            if (objectArgs.size() > 5) {
                throw new ExprEvalException(FmtUtils.stringForNode(predicate) + ": Maximum of 5 arguments.");
            }
            Node latMin = objectArgs.get(0);
            Node lonMin = objectArgs.get(1);
            Node latMax = objectArgs.get(2);
            Node lonMax = objectArgs.get(3);
            if (latMin.isVariable() || lonMin.isVariable() || latMax.isVariable() || lonMax.isVariable()) {
                throw new ExprEvalException("Arguments are not all concrete: " + FmtUtils.stringForNode(latMin) + ", " + FmtUtils.stringForNode(lonMin) + FmtUtils.stringForNode(latMax) + ", " + FmtUtils.stringForNode(lonMax));
            }
            if (objectArgs.size() > 4) {
                NodeValue limitNode = NodeValue.makeNode(objectArgs.get(4));
                if (!limitNode.isInteger()) {
                    throw new ExprEvalException("Not an integer: " + FmtUtils.stringForNode(limitNode.getNode()));
                }
                limit = limitNode.getInteger().intValue();
            } else {
                limit = -1;
            }
            Node geometryNode = ConvertLatLonBox.toNode(latMin, lonMin, latMax, lonMax);
            GeometryWrapper geometryWrapper = GeometryWrapper.extract(geometryNode);
            SearchEnvelope searchEnvelope = SearchEnvelope.build(geometryWrapper, indexSRSInfo);
            return new SpatialArguments(limit, geometryWrapper, searchEnvelope);
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }
}

