/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

public final class TermSelector {
    private final ActiveContext activeContext;
    private final String variable;
    private final Collection<String> containers;
    private final String typeLanguage;

    private TermSelector(ActiveContext activeContext, String variable, Collection<String> containers, String typeLanguage) {
        this.activeContext = activeContext;
        this.variable = variable;
        this.containers = containers;
        this.typeLanguage = typeLanguage;
    }

    public static TermSelector with(ActiveContext activeContext, String variable, Collection<String> containers, String typeLanguage) {
        return new TermSelector(activeContext, variable, containers, typeLanguage);
    }

    public Optional<String> match(Collection<String> preferredValues) {
        if (this.activeContext.getInverseContext() == null) {
            this.activeContext.createInverseContext();
        }
        InverseContext inverseContext = this.activeContext.getInverseContext();
        return this.containers.stream().filter(container2 -> inverseContext.contains(this.variable, (String)container2, this.typeLanguage)).flatMap(container2 -> preferredValues.stream().map(item -> inverseContext.get(this.variable, (String)container2, this.typeLanguage, (String)item))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).findFirst();
    }
}

