/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBase;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.lib.DumpOps;
import org.apache.jena.tdb1.solver.BindingNodeId;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;

public class BindingTDB
extends BindingBase {
    private final NodeTable nodeTable;
    private final BindingNodeId idBinding;
    private static final boolean caching = false;
    private final Map<Var, Node> cache = null;
    private List<Var> vars = null;

    public BindingTDB(BindingNodeId idBinding, NodeTable nodeTable) {
        super(idBinding.getParentBinding());
        this.idBinding = idBinding;
        this.nodeTable = nodeTable;
    }

    protected int size1() {
        return this.idBinding.size();
    }

    protected Iterator<Var> vars1() {
        if (this.vars == null) {
            this.vars = this.calcVars();
        }
        return this.vars.iterator();
    }

    private List<Var> calcVars() {
        ArrayList<Var> vars = new ArrayList<Var>(4);
        Binding b = this.idBinding.getParentBinding();
        Iterator iter = this.idBinding.iterator();
        Iterator iterator = this.idBinding.iterator();
        while (iterator.hasNext()) {
            Var v = (Var)iterator.next();
            if (b != null && b.contains(v)) continue;
            vars.add(v);
        }
        return vars;
    }

    protected boolean isEmpty1() {
        return this.size1() == 0;
    }

    public boolean contains1(Var var) {
        return this.idBinding.containsKey(var);
    }

    public BindingNodeId getBindingId() {
        return this.idBinding;
    }

    public NodeId getNodeId(Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        if (id != null) {
            return id;
        }
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (this.parent == null) {
            return null;
        }
        Binding binding = this.parent;
        if (binding instanceof BindingTDB) {
            BindingTDB bindingTDB = (BindingTDB)binding;
            return bindingTDB.getNodeId(var);
        }
        return null;
    }

    public Node get1(Var var) {
        try {
            Node n = this.cacheGet(var);
            if (n != null) {
                return n;
            }
            NodeId id = (NodeId)this.idBinding.get(var);
            if (id == null) {
                return null;
            }
            if (NodeId.isDoesNotExist(id)) {
                return null;
            }
            n = this.nodeTable.getNodeForNodeId(id);
            if (n == null) {
                n = this.nodeTable.getNodeForNodeId(id);
                DumpOps.dumpNodeTable(this.nodeTable);
                throw new TDB1Exception("No node in NodeTable for NodeId " + String.valueOf(id));
            }
            this.cachePut(var, n);
            return n;
        }
        catch (Exception ex) {
            Log.error((Object)((Object)this), (String)String.format("get1(%s)", var), (Throwable)ex);
            return null;
        }
    }

    private void cachePut(Var var, Node n) {
        if (this.cache != null) {
            this.cache.put(var, n);
        }
    }

    private Node cacheGet(Var var) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(var);
    }

    protected void fmtVar(StringBuilder sbuff, Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        Object extra = "";
        if (id != null) {
            extra = "/" + String.valueOf(id);
        }
        Node node = this.get(var);
        String tmp = NodeFmtLib.displayStr((Node)node);
        sbuff.append("( ?" + var.getVarName() + (String)extra + " = " + tmp + " )");
    }

    public Binding detach() {
        return BindingFactory.copy((Binding)this);
    }

    protected Binding detachWithNewParent(Binding newParent) {
        throw new UnsupportedOperationException("Should never be called.");
    }
}

