/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.util.FmtUtils;

public abstract class BindingBase
implements Binding {
    protected Binding parent;

    protected BindingBase(Binding _parent) {
        this.parent = _parent;
    }

    @Override
    public final Iterator<Var> vars() {
        Iterator iter = this.vars1();
        if (this.parent != null) {
            iter = IteratorConcat.concat(this.parent.vars(), iter);
        }
        return iter;
    }

    @Override
    public final Set<Var> varsMentioned() {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        this.vars().forEachRemaining(result::add);
        return result;
    }

    @Override
    public void forEach(BiConsumer<Var, Node> action) {
        this.forEach1(action);
        if (this.parent != null) {
            this.parent.forEach(action);
        }
    }

    protected void forEach1(BiConsumer<Var, Node> action) {
        Iterator<Var> vIter = this.vars1();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            Node n = this.get(v);
            action.accept(v, n);
        }
    }

    protected abstract Iterator<Var> vars1();

    @Override
    public final int size() {
        int x = this.size1();
        if (this.parent != null) {
            x += this.parent.size();
        }
        return x;
    }

    protected abstract int size1();

    @Override
    public boolean isEmpty() {
        if (!this.isEmpty1()) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        return this.parent.isEmpty();
    }

    protected abstract boolean isEmpty1();

    @Override
    public final boolean contains(Var var) {
        if (this.contains1(var)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(var);
    }

    protected abstract boolean contains1(Var var1);

    @Override
    public final Node get(Var var) {
        Node node = this.get1(var);
        if (node != null) {
            return node;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(var);
    }

    protected abstract Node get1(Var var1);

    public String toString() {
        String tmp;
        StringBuilder sbuff = new StringBuilder();
        this.format1(sbuff);
        if (this.parent != null && (tmp = this.parent.toString()) != null && tmp.length() != 0) {
            sbuff.append(" -> ");
            sbuff.append(tmp);
        }
        return sbuff.toString();
    }

    public void format1(StringBuilder sbuff) {
        if (this.isEmpty()) {
            sbuff.append("()");
            return;
        }
        String sep = "";
        Iterator<Var> iter = this.vars1();
        while (iter.hasNext()) {
            Var obj;
            Var var = obj = iter.next();
            sbuff.append(sep);
            sep = " ";
            this.fmtVar(sbuff, var);
        }
    }

    protected void fmtVar(StringBuilder sbuff, Var var) {
        Node node = this.get(var);
        String tmp = FmtUtils.stringForObject(node);
        sbuff.append("( ?" + var.getVarName() + " = " + tmp + " )");
    }

    public String toString1() {
        StringBuilder sbuff = new StringBuilder();
        this.format1(sbuff);
        return sbuff.toString();
    }

    @Override
    public int hashCode() {
        return BindingBase.hashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)other;
        return BindingLib.equals(this, binding);
    }

    public static int hashCode(Binding bind) {
        int hash = 192;
        Iterator<Var> iter = bind.vars();
        while (iter.hasNext()) {
            Var var = iter.next();
            Node node = bind.get(var);
            hash ^= var.hashCode();
            hash ^= node.hashCode();
        }
        return hash;
    }

    @Override
    public Binding detach() {
        Binding newParent = this.parent == null ? null : this.parent.detach();
        Binding result = newParent == this.parent ? this.detachWithOriginalParent() : this.detachWithNewParent(newParent);
        return result;
    }

    protected Binding detachWithOriginalParent() {
        return this;
    }

    protected abstract Binding detachWithNewParent(Binding var1);
}

