/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.Limit;

public class ArrayOutputStream
extends OutputStream
implements Limit {
    private byte[] pageData;
    private int start;
    private int end;
    private int position;

    public ArrayOutputStream() {
    }

    public ArrayOutputStream(byte[] byArray) {
        this.setData(byArray);
    }

    public void setData(byte[] byArray) {
        this.pageData = byArray;
        this.start = 0;
        this.end = byArray != null ? byArray.length : 0;
        this.position = 0;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.position >= this.end) {
            throw new EOFException();
        }
        this.pageData[this.position++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.position + n2 > this.end) {
            throw new EOFException();
        }
        System.arraycopy(byArray, n, this.pageData, this.position, n2);
        this.position += n2;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) throws IOException {
        if (n < this.start || n > this.end) {
            throw new EOFException();
        }
        this.position = n;
    }

    @Override
    public void setLimit(int n) throws IOException {
        if (n < 0) {
            throw new EOFException();
        }
        if (this.position + n > this.end) {
            throw new EOFException();
        }
        this.start = this.position;
        this.end = this.position + n;
    }

    @Override
    public int clearLimit() {
        int n = this.end - this.position;
        this.end = this.pageData.length;
        return n;
    }
}

