/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountSearchOperation;
import com.unboundid.ldap.sdk.unboundidds.tools.ManageAccountSearchProcessor;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;

final class ManageAccountSearchProcessorThread
extends Thread {
    @NotNull
    private final ManageAccountSearchProcessor searchProcessor;
    @Nullable
    private volatile ManageAccountSearchOperation activeSearchOperation;

    ManageAccountSearchProcessorThread(int threadNumber, @NotNull ManageAccountSearchProcessor searchProcessor) {
        this.setName("manage-account Search Processor Thread " + threadNumber);
        this.searchProcessor = searchProcessor;
        this.activeSearchOperation = null;
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.activeSearchOperation = this.searchProcessor.getSearchOperation();
                if (this.activeSearchOperation == null) {
                    return;
                }
                this.activeSearchOperation.doSearch();
                continue;
            }
            finally {
                this.activeSearchOperation = null;
                continue;
            }
            break;
        }
    }

    void cancelSearch() {
        ManageAccountSearchOperation o = this.activeSearchOperation;
        if (o != null) {
            o.cancelSearch();
        }
    }
}

