/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

public class FunctionQuery
extends Query {
    final ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new FunctionWeight(searcher, boost);
    }

    public String toString(String field) {
        return this.func.toString();
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.func.equals(((FunctionQuery)((Object)other)).func);
    }

    public int hashCode() {
        return this.classHash() ^ this.func.hashCode();
    }

    protected class FunctionWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected final float boost;
        protected final Map<Object, Object> context;

        public FunctionWeight(IndexSearcher searcher, float boost) throws IOException {
            super((Query)FunctionQuery.this);
            this.searcher = searcher;
            this.context = ValueSource.newContext(searcher);
            FunctionQuery.this.func.createWeight(this.context, searcher);
            this.boost = boost;
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            AllScorer scorer = new AllScorer(context, this, this.boost);
            return new Weight.DefaultScorerSupplier((Scorer)scorer);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return ((AllScorer)this.scorer(context)).explain(doc);
        }
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float boost;
        final DocIdSetIterator iterator;
        final FunctionValues vals;

        public AllScorer(LeafReaderContext context, FunctionWeight w, float boost) throws IOException {
            this.weight = w;
            this.boost = boost;
            this.reader = context.reader();
            this.maxDoc = this.reader.maxDoc();
            this.iterator = DocIdSetIterator.all((int)context.reader().maxDoc());
            this.vals = FunctionQuery.this.func.getValues(this.weight.context, context);
        }

        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        public int docID() {
            return this.iterator.docID();
        }

        public float score() throws IOException {
            float val = this.vals.floatVal(this.docID());
            if (!(val >= 0.0f)) {
                return 0.0f;
            }
            return this.boost * val;
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }

        public Explanation explain(int doc) throws IOException {
            Explanation expl = this.vals.explain(doc);
            if (expl.getValue().floatValue() < 0.0f) {
                expl = Explanation.match((Number)0, (String)"truncated score, max of:", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(0.0f), (String)"minimum score", (Explanation[])new Explanation[0]), expl});
            } else if (Float.isNaN(expl.getValue().floatValue())) {
                expl = Explanation.match((Number)0, (String)"score, computed as (score == NaN ? 0 : score) since NaN is an illegal score from:", (Explanation[])new Explanation[]{expl});
            }
            return Explanation.match((Number)Float.valueOf(this.boost * expl.getValue().floatValue()), (String)("FunctionQuery(" + String.valueOf(FunctionQuery.this.func) + "), product of:"), (Explanation[])new Explanation[]{this.vals.explain(doc), Explanation.match((Number)Float.valueOf(this.weight.boost), (String)"boost", (Explanation[])new Explanation[0])});
        }
    }
}

