/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSizeEsmtpExtension
implements MailParametersHook,
EhloExtension,
DataLineFilter,
MessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSizeEsmtpExtension.class);
    private static final ProtocolSession.AttachmentKey<Integer> MESG_SIZE = ProtocolSession.AttachmentKey.of((String)"MESG_SIZE", Integer.class);
    private static final String[] MAIL_PARAMS = new String[]{"SIZE"};
    private static final HookResult SYNTAX_ERROR = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("501").smtpDescription(DSNStatus.getStatus(5, "5.4") + " Syntactically incorrect value for SIZE parameter").build();
    private static final HookResult QUOTA_EXCEEDED = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("552").smtpDescription(DSNStatus.getStatus(5, "3.4") + " Message size exceeds fixed maximum message size").build();
    public static final int SINGLE_CHARACTER_LINE = 3;
    public static final int DOT_BYTE = 46;

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        MaybeSender tempSender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        session.setMessageFailed(false);
        return this.doMailSize(session, paramValue, tempSender);
    }

    @Override
    public String[] getMailParamNames() {
        return MAIL_PARAMS;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        long maxMessageSize = session.getConfiguration().getMaxMessageSize();
        if (maxMessageSize > 0L) {
            return Arrays.asList("SIZE " + maxMessageSize);
        }
        return Collections.emptyList();
    }

    private HookResult doMailSize(SMTPSession session, String mailOptionValue, MaybeSender tempSender) {
        int size = 0;
        try {
            size = Integer.parseInt(mailOptionValue);
        }
        catch (NumberFormatException pe) {
            LOGGER.error("Rejected syntactically incorrect value for SIZE parameter.");
            return SYNTAX_ERROR;
        }
        LOGGER.debug("MAIL command option SIZE received with value {}.", (Object)size);
        long maxMessageSize = session.getConfiguration().getMaxMessageSize();
        if (maxMessageSize > 0L && (long)size > maxMessageSize) {
            LOGGER.info("Rejected message from {} to {} of size {} exceeding system maximum message size of {} based on SIZE option.", new Object[]{tempSender.asPrettyString(), session.getRemoteAddress().getAddress().getHostAddress(), size, maxMessageSize});
            return QUOTA_EXCEEDED;
        }
        session.setAttachment(MESG_SIZE, size, ProtocolSession.State.Transaction);
        return null;
    }

    @Override
    public Response onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        boolean failed = session.messageFailed();
        if (failed) {
            if (this.isDataTerminated(line)) {
                next.onLine((ProtocolSession)session, line);
                return new SMTPResponse("552", "Quota exceeded");
            }
            return null;
        }
        if (this.isDataTerminated(line)) {
            return next.onLine((ProtocolSession)session, line);
        }
        Long newSize = Optional.ofNullable(session.currentMessageSize()).map(currentSize -> currentSize.intValue() + line.length).orElseGet(() -> line.length);
        session.setCurrentMessageSize(newSize);
        if (session.getConfiguration().getMaxMessageSize() > 0L && (long)newSize.intValue() > session.getConfiguration().getMaxMessageSize()) {
            session.setMessageFailed(true);
            return null;
        }
        return next.onLine((ProtocolSession)session, line);
    }

    private boolean isDataTerminated(byte[] line) {
        return line.length == 3 && line[0] == 46;
    }

    @Override
    public HookResult onMessage(SMTPSession session, MailEnvelope mail) {
        boolean failed = session.messageFailed();
        if (failed) {
            LOGGER.info("Rejected message from {} from {} exceeding system maximum message size of {}", new Object[]{session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender()).asPrettyString(), session.getRemoteAddress().getAddress().getHostAddress(), session.getConfiguration().getMaxMessageSize()});
            return QUOTA_EXCEEDED;
        }
        return HookResult.DECLINED;
    }
}

