/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.Flags;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.DeniedAccessOnSharedMailboxException;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.ExpungeResponse;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.message.response.FlagsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.message.response.VanishedResponse;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.base.AbstractProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.NullableMessageSequenceNumber;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public abstract class AbstractMailboxProcessor<R extends ImapRequest>
extends AbstractProcessor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailboxProcessor.class);
    public static final String IMAP_PREFIX = "IMAP-";
    private final MailboxManager mailboxManager;
    private final StatusResponseFactory factory;
    private final MetricFactory metricFactory;

    public AbstractMailboxProcessor(Class<R> acceptableClass, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass);
        this.mailboxManager = mailboxManager;
        this.factory = factory;
        this.metricFactory = metricFactory;
    }

    @Override
    protected final Mono<Void> doProcess(R acceptableMessage, ImapProcessor.Responder responder, ImapSession session) {
        if (acceptableMessage.getCommand().validForState(session.getState())) {
            MailboxSession mailboxSession = session.getMailboxSession();
            return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric(IMAP_PREFIX + acceptableMessage.getCommand().getName(), (Publisher)this.mailboxManager.manageProcessing(this.processRequestReactive(acceptableMessage, session, responder).onErrorResume(DeniedAccessOnSharedMailboxException.class, e -> {
                this.no((ImapRequest)acceptableMessage, responder, HumanReadableText.DENIED_SHARED_MAILBOX);
                return Mono.empty();
            }).onErrorResume(InsufficientRightsException.class, e -> {
                this.no((ImapRequest)acceptableMessage, responder, HumanReadableText.UNSUFFICIENT_RIGHTS);
                return ReactorUtils.logAsMono(() -> LOGGER.warn("Processing failed due to insufficient rights", (Throwable)e));
            }).onErrorResume(OverQuotaException.class, e -> {
                this.no((ImapRequest)acceptableMessage, responder, HumanReadableText.FAILURE_OVERQUOTA, StatusResponse.ResponseCode.overQuota());
                return ReactorUtils.logAsMono(() -> LOGGER.info("Processing failed due to quota restriction", (Throwable)e));
            }).onErrorResume(e -> {
                this.no((ImapRequest)acceptableMessage, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
                return ReactorUtils.logAsMono(() -> LOGGER.error("Unexpected error during IMAP processing", e));
            }), mailboxSession)));
        }
        StatusResponse response = this.factory.taggedNo(acceptableMessage.getTag(), acceptableMessage.getCommand(), HumanReadableText.INVALID_COMMAND);
        responder.respond(response);
        return Mono.empty();
    }

    protected void flags(ImapProcessor.Responder responder, SelectedMailbox selected) {
        responder.respond(new FlagsResponse(selected.getApplicableFlags()));
    }

    protected void permanentFlags(ImapProcessor.Responder responder, Flags permanentFlags, SelectedMailbox selected) {
        if (permanentFlags.contains(Flags.Flag.USER)) {
            permanentFlags.add(selected.getApplicableFlags());
        }
        StatusResponse untaggedOk = this.factory.untaggedOk(HumanReadableText.permanentFlags(permanentFlags), StatusResponse.ResponseCode.permanentFlags(permanentFlags));
        responder.respond(untaggedOk);
    }

    protected Mono<Void> unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, boolean useUids) {
        return this.unsolicitedResponses(session, responder, false, useUids);
    }

    protected Mono<Void> unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, boolean omitExpunged, boolean useUid) {
        SelectedMailbox selected = session.getSelected();
        if (selected == null) {
            LOGGER.debug("No mailbox selected");
            return Mono.empty();
        }
        return this.unsolicitedResponses(session, responder, selected, omitExpunged, useUid);
    }

    private Mono<Void> unsolicitedResponses(ImapSession session, ImapProcessor.Responder responder, SelectedMailbox selected, boolean omitExpunged, boolean useUid) {
        return Mono.fromRunnable(() -> {
            Collection<MessageUid> expungedUids;
            boolean sizeChanged = selected.isSizeChanged();
            if (sizeChanged) {
                this.addExistsResponses(selected, responder);
            }
            if (!omitExpunged && !(expungedUids = selected.expungedUids()).isEmpty()) {
                if (EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
                    this.addVanishedResponse(selected, expungedUids, responder);
                } else {
                    this.addExpungedResponses(selected, expungedUids, responder);
                }
                selected.resetExpungedUids();
            }
            if (sizeChanged || selected.isRecentUidRemoved() && !omitExpunged) {
                this.addRecentResponses(selected, responder);
                selected.resetRecentUidRemoved();
            }
        }).then(this.addFlagsResponses(session, selected, responder, useUid)).then(Mono.fromRunnable(selected::resetEvents));
    }

    private void addExpungedResponses(SelectedMailbox selected, Collection<MessageUid> expungedUids, ImapProcessor.Responder responder) {
        for (MessageUid uid : expungedUids) {
            NullableMessageSequenceNumber msn = selected.remove(uid);
            ExpungeResponse response = new ExpungeResponse(msn);
            responder.respond(response);
        }
    }

    private void addVanishedResponse(SelectedMailbox selected, Collection<MessageUid> expungedUids, ImapProcessor.Responder responder) {
        for (MessageUid uid : expungedUids) {
            selected.remove(uid);
        }
        UidRange[] uidRange = this.uidRanges(MessageRange.toRanges(expungedUids));
        responder.respond(new VanishedResponse(uidRange, false));
    }

    private Mono<Void> addFlagsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid) {
        MessageManager messageManager = selected.getMessageManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        Collection<MessageUid> flagUpdateUids = selected.flagUpdateUids();
        if (!flagUpdateUids.isEmpty()) {
            return Mono.fromRunnable(() -> this.addApplicableFlagResponse(session, selected, responder, useUid)).then(Flux.fromIterable((Iterable)MessageRange.toRanges(flagUpdateUids)).concatMap(range -> this.addFlagsResponses(session, selected, responder, useUid, (MessageRange)range, messageManager, mailboxSession)).then().onErrorResume(MailboxException.class, e -> {
                this.handleResponseException(responder, (MailboxException)e, HumanReadableText.FAILURE_TO_LOAD_FLAGS, session);
                return Mono.empty();
            }));
        }
        return Mono.fromRunnable(() -> this.addApplicableFlagResponse(session, selected, responder, useUid));
    }

    private void addApplicableFlagResponse(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid) {
        MessageManager messageManager = selected.getMessageManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        if (selected.hasNewApplicableFlags()) {
            this.flags(responder, selected);
            this.permanentFlags(responder, messageManager.getPermanentFlags(mailboxSession), selected);
            selected.resetNewApplicableFlags();
        }
    }

    private Mono<Void> addFlagsResponses(ImapSession session, SelectedMailbox selected, ImapProcessor.Responder responder, boolean useUid, MessageRange messageSet, MessageManager mailbox, MailboxSession mailboxSession) {
        boolean qresyncEnabled = EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC);
        boolean condstoreEnabled = EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_CONDSTORE);
        return Flux.from((Publisher)mailbox.listMessagesMetadata(messageSet, mailboxSession)).doOnNext((Consumer)Throwing.consumer(mr -> {
            MessageUid uid = mr.getComposedMessageId().getUid();
            selected.msn(uid).fold(() -> {
                LOGGER.debug("No message found with uid {} in the uid<->msn mapping for mailbox {}. This may be because it was deleted by a concurrent session. So skip it..", (Object)uid, (Object)selected.getMailboxId().serialize());
                return null;
            }, msn -> {
                Flags flags = mr.getFlags();
                Object uidOut = useUid || qresyncEnabled ? uid : null;
                if (selected.isRecent(uid)) {
                    flags.add(Flags.Flag.RECENT);
                } else {
                    flags.remove(Flags.Flag.RECENT);
                }
                FetchResponse response = condstoreEnabled || qresyncEnabled ? new FetchResponse(msn, flags, (MessageUid)uidOut, null, mr.getModSeq(), null, null, null, null, null, null, null, null) : new FetchResponse(msn, flags, (MessageUid)uidOut, null, null, null, null, null, null, null, null, null, null);
                responder.respond(response);
                return null;
            });
        })).then();
    }

    protected void condstoreEnablingCommand(ImapSession session, ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData, boolean sendHighestModSeq) {
        Set<Capability> enabled = EnableProcessor.getEnabledCapabilities(session);
        if (!enabled.contains(ImapConstants.SUPPORTS_CONDSTORE)) {
            if (sendHighestModSeq) {
                ModSeq highestModSeq = metaData.getHighestModSeq();
                StatusResponse untaggedOk = this.getStatusResponseFactory().untaggedOk(HumanReadableText.HIGHEST_MOD_SEQ, StatusResponse.ResponseCode.highestModSeq(highestModSeq));
                responder.respond(untaggedOk);
            }
            enabled.add(ImapConstants.SUPPORTS_CONDSTORE);
        }
    }

    private void addRecentResponses(SelectedMailbox selected, ImapProcessor.Responder responder) {
        int recentCount = selected.recentCount();
        RecentResponse response = new RecentResponse(recentCount);
        responder.respond(response);
    }

    private void addExistsResponses(SelectedMailbox selected, ImapProcessor.Responder responder) {
        long existsCount = selected.existsCount();
        ExistsResponse response = new ExistsResponse(existsCount);
        responder.respond(response);
    }

    private void handleResponseException(ImapProcessor.Responder responder, MailboxException e, HumanReadableText message, ImapSession session) {
        LOGGER.error("{}", (Object)message, (Object)e);
        StatusResponse response = this.factory.untaggedNo(message);
        responder.respond(response);
    }

    protected void okComplete(ImapRequest request, ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.taggedOk(request.getTag(), request.getCommand(), HumanReadableText.COMPLETED);
        responder.respond(response);
    }

    protected void okComplete(ImapRequest request, StatusResponse.ResponseCode code, ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.taggedOk(request.getTag(), request.getCommand(), HumanReadableText.COMPLETED, code);
        responder.respond(response);
    }

    protected void no(ImapRequest request, ImapProcessor.Responder responder, HumanReadableText displayTextKey) {
        StatusResponse response = this.factory.taggedNo(request.getTag(), request.getCommand(), displayTextKey);
        responder.respond(response);
    }

    protected void no(ImapRequest request, ImapProcessor.Responder responder, HumanReadableText displayTextKey, StatusResponse.ResponseCode responseCode) {
        StatusResponse response = this.factory.taggedNo(request.getTag(), request.getCommand(), displayTextKey, responseCode);
        responder.respond(response);
    }

    protected void taggedBad(ImapRequest request, ImapProcessor.Responder responder, HumanReadableText e) {
        StatusResponse response = this.factory.taggedBad(request.getTag(), request.getCommand(), e);
        responder.respond(response);
    }

    protected void bye(ImapProcessor.Responder responder) {
        StatusResponse response = this.factory.bye(HumanReadableText.BYE);
        responder.respond(response);
    }

    protected void bye(ImapProcessor.Responder responder, HumanReadableText key) {
        StatusResponse response = this.factory.bye(key);
        responder.respond(response);
    }

    protected void processRequest(R request, ImapSession session, ImapProcessor.Responder responder) {
        this.processRequestReactive(request, session, responder).block();
    }

    protected Mono<Void> processRequestReactive(R request, ImapSession session, ImapProcessor.Responder responder) {
        return Mono.deferContextual(context -> Mono.fromRunnable(() -> {
            try (Closeable mdc = ReactorUtils.retrieveMDCBuilder((ContextView)context).build();){
                this.processRequest(request, session, responder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    protected StatusResponseFactory getStatusResponseFactory() {
        return this.factory;
    }

    protected Mono<MessageManager> getSelectedMailboxReactive(ImapSession session, Mono<MessageManager> ifEmpty) {
        return Optional.ofNullable(session.getSelected()).map(selectedMailbox -> Mono.from((Publisher)this.getMailboxManager().getMailboxReactive(selectedMailbox.getMailboxId(), session.getMailboxSession()))).orElse(ifEmpty);
    }

    protected Mono<MessageManager> getSelectedMailboxReactive(ImapSession session) {
        return this.getSelectedMailboxReactive(session, (Mono<MessageManager>)Mono.error(() -> new MailboxException("Session not in SELECTED state")));
    }

    protected Optional<MessageRange> messageRange(SelectedMailbox selected, IdRange range, boolean useUids) throws MessageRangeException {
        long lowVal = range.getLowVal();
        long highVal = range.getHighVal();
        if (!useUids) {
            return Optional.of(this.msnRangeToMessageRange(selected, lowVal, highVal));
        }
        if (selected.existsCount() <= 0L) {
            return Optional.empty();
        }
        MessageUid lastUid = selected.getLastUid().orElse(MessageUid.MIN_VALUE);
        if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
            return Optional.of(MessageRange.one((MessageUid)lastUid));
        }
        if (highVal == Long.MAX_VALUE && lastUid.compareTo(MessageUid.of((long)lowVal)) < 0) {
            return Optional.of(MessageRange.one((MessageUid)lastUid));
        }
        return Optional.of(MessageRange.range((MessageUid)MessageUid.of((long)lowVal), (MessageUid)MessageUid.of((long)highVal)));
    }

    private MessageRange msnRangeToMessageRange(SelectedMailbox selected, long lowVal, long highVal) throws MessageRangeException {
        if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
            return selected.getLastUid().map(MessageRange::one).orElseGet(MessageRange::all);
        }
        if (lowVal == 1L && highVal == Long.MAX_VALUE) {
            return MessageRange.all();
        }
        MessageUid lowUid = this.msnlowValToUid(selected, lowVal);
        MessageUid highUid = this.msnHighValToUid(selected, highVal);
        return MessageRange.range((MessageUid)lowUid, (MessageUid)highUid);
    }

    private MessageUid msnlowValToUid(SelectedMailbox selected, long lowVal) throws MessageRangeException {
        Optional<MessageUid> uid;
        if (lowVal != Long.MIN_VALUE) {
            uid = selected.uid((int)lowVal);
            if (!uid.isPresent()) {
                throw new MessageRangeException("No message found with msn " + lowVal);
            }
        } else {
            uid = selected.getFirstUid();
            if (!uid.isPresent()) {
                throw new MessageRangeException("Mailbox is empty");
            }
        }
        return uid.get();
    }

    private MessageUid msnHighValToUid(SelectedMailbox selected, long highVal) throws MessageRangeException {
        Optional<MessageUid> uid;
        if (highVal != Long.MAX_VALUE) {
            uid = selected.uid((int)highVal);
            if (!uid.isPresent()) {
                throw new MessageRangeException("No message found with msn " + highVal);
            }
        } else {
            uid = selected.getLastUid();
            if (!uid.isPresent()) {
                throw new MessageRangeException("Mailbox is empty");
            }
        }
        return uid.get();
    }

    protected MessageRange normalizeMessageRange(SelectedMailbox selected, MessageRange range) {
        MessageRange.Type rangeType = range.getType();
        switch (rangeType) {
            case ONE: {
                return range;
            }
            case ALL: {
                MessageUid start = selected.getFirstUid().orElse(MessageUid.MIN_VALUE);
                MessageUid end = selected.getLastUid().orElse(MessageUid.MAX_VALUE);
                return MessageRange.range((MessageUid)start, (MessageUid)end);
            }
            case RANGE: {
                MessageUid end;
                MessageUid start = range.getUidFrom();
                if (start.equals((Object)MessageUid.MAX_VALUE) || start.compareTo(selected.getFirstUid().orElse(MessageUid.MIN_VALUE)) < 0) {
                    start = selected.getFirstUid().orElse(MessageUid.MIN_VALUE);
                }
                if ((end = range.getUidTo()).equals((Object)MessageUid.MAX_VALUE) || end.compareTo(selected.getLastUid().orElse(MessageUid.MAX_VALUE)) > 0) {
                    end = selected.getLastUid().orElse(MessageUid.MAX_VALUE);
                }
                return MessageRange.range((MessageUid)start, (MessageUid)end);
            }
            case FROM: {
                MessageUid start = range.getUidFrom();
                if (start.equals((Object)MessageUid.MAX_VALUE) || start.compareTo(selected.getFirstUid().orElse(MessageUid.MIN_VALUE)) < 0) {
                    start = selected.getFirstUid().orElse(MessageUid.MIN_VALUE);
                }
                MessageUid end = selected.getLastUid().orElse(MessageUid.MAX_VALUE);
                return MessageRange.range((MessageUid)start, (MessageUid)end);
            }
        }
        throw new RuntimeException("Unknown message range type: " + String.valueOf(rangeType));
    }

    protected void respondVanished(SelectedMailbox selectedMailbox, List<MessageRange> ranges, ImapProcessor.Responder responder) {
        HashSet vanishedUids = new HashSet();
        for (MessageRange range : ranges) {
            MessageUid from = range.getUidFrom();
            MessageUid to = range.getUidTo();
            while (from.compareTo(to) <= 0) {
                MessageUid copy = from;
                selectedMailbox.msn(from).foldSilent(() -> vanishedUids.add(copy), msn -> true);
                from = from.next();
            }
        }
        UidRange[] vanishedIdRanges = this.uidRanges(MessageRange.toRanges(vanishedUids));
        if (vanishedIdRanges.length > 0) {
            responder.respond(new VanishedResponse(vanishedIdRanges, true));
        }
    }

    protected UidRange[] uidRanges(Collection<MessageRange> mRanges) {
        UidRange[] idRanges = new UidRange[mRanges.size()];
        Iterator<MessageRange> mIt = mRanges.iterator();
        int i = 0;
        while (mIt.hasNext()) {
            MessageRange mr = mIt.next();
            UidRange ir = mr.getType() == MessageRange.Type.ONE ? new UidRange(mr.getUidFrom()) : new UidRange(mr.getUidFrom(), mr.getUidTo());
            idRanges[i++] = ir;
        }
        return idRanges;
    }
}

