/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.versions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraSchemaVersionManager {
    public static final SchemaVersion MIN_VERSION = new SchemaVersion(12);
    public static final SchemaVersion MAX_VERSION = new SchemaVersion(15);
    public static final SchemaVersion DEFAULT_VERSION = MIN_VERSION;
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraSchemaVersionManager.class);
    private final SchemaVersion minVersion;
    private final SchemaVersion maxVersion;
    private final SchemaVersion initialSchemaVersion;
    private final CassandraSchemaVersionDAO schemaVersionDAO;

    @Inject
    public CassandraSchemaVersionManager(CassandraSchemaVersionDAO schemaVersionDAO) {
        this(schemaVersionDAO, MIN_VERSION, MAX_VERSION);
    }

    @VisibleForTesting
    public CassandraSchemaVersionManager(CassandraSchemaVersionDAO schemaVersionDAO, SchemaVersion minVersion, SchemaVersion maxVersion) {
        Preconditions.checkArgument((boolean)maxVersion.isAfterOrEquals(minVersion), (Object)"maxVersion should not be inferior to minVersion");
        this.schemaVersionDAO = schemaVersionDAO;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.initialSchemaVersion = (SchemaVersion)this.computeVersion().block();
    }

    public Mono<Boolean> isBefore(SchemaVersion minimum) {
        if (this.initialSchemaVersion.isBefore(minimum)) {
            return this.computeVersion().map(computedVersion -> computedVersion.isBefore(minimum));
        }
        return Mono.just((Object)false);
    }

    public Mono<SchemaVersion> computeVersion() {
        return this.schemaVersionDAO.getCurrentSchemaVersion().map(maybeVersion -> maybeVersion.orElseGet(() -> {
            LOGGER.warn("No schema version information found on Cassandra, we assume schema is at version {}", (Object)DEFAULT_VERSION);
            return DEFAULT_VERSION;
        }));
    }

    public SchemaVersion getMinimumSupportedVersion() {
        return this.minVersion;
    }

    public SchemaVersion getMaximumSupportedVersion() {
        return this.maxVersion;
    }

    public SchemaState computeSchemaState() {
        SchemaVersion version = (SchemaVersion)this.computeVersion().block();
        if (version.isBefore(this.minVersion)) {
            return SchemaState.TOO_OLD;
        }
        if (version.isBefore(this.maxVersion)) {
            return SchemaState.UPGRADABLE;
        }
        if (version.equals(this.maxVersion)) {
            return SchemaState.UP_TO_DATE;
        }
        return SchemaState.TOO_RECENT;
    }

    public static enum SchemaState {
        UP_TO_DATE,
        TOO_RECENT,
        TOO_OLD,
        UPGRADABLE;

    }
}

