/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.healthcheck;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.ResultStatus;

public class Result {
    private final ComponentName componentName;
    private final ResultStatus status;
    private final Optional<String> cause;
    private final Optional<Throwable> error;

    public static Result healthy(ComponentName componentName) {
        return new Result(componentName, ResultStatus.HEALTHY, Optional.empty(), Optional.empty());
    }

    public static Result unhealthy(ComponentName componentName, String cause) {
        return new Result(componentName, ResultStatus.UNHEALTHY, Optional.of(cause), Optional.empty());
    }

    public static Result unhealthy(ComponentName componentName, String cause, Throwable error) {
        return new Result(componentName, ResultStatus.UNHEALTHY, Optional.of(cause), Optional.of(error));
    }

    public static Result degraded(ComponentName componentName, String cause) {
        return new Result(componentName, ResultStatus.DEGRADED, Optional.of(cause), Optional.empty());
    }

    private Result(ComponentName componentName, ResultStatus status, Optional<String> cause, Optional<Throwable> error) {
        this.componentName = componentName;
        this.status = status;
        this.cause = cause;
        this.error = error;
    }

    public ComponentName getComponentName() {
        return this.componentName;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public Optional<String> getCause() {
        return this.cause;
    }

    public Optional<Throwable> getError() {
        return this.error;
    }

    public boolean isHealthy() {
        return this.status == ResultStatus.HEALTHY;
    }

    public boolean isDegraded() {
        return this.status == ResultStatus.DEGRADED;
    }

    public boolean isUnHealthy() {
        return this.status == ResultStatus.UNHEALTHY;
    }

    public final boolean equals(Object o) {
        if (o instanceof Result) {
            Result result = (Result)o;
            return Objects.equals(this.componentName, result.componentName) && Objects.equals((Object)this.status, (Object)result.status) && Objects.equals(this.cause, result.cause) && Objects.equals(this.error, result.error);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.componentName, this.status, this.cause, this.error});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("componentName", (Object)this.componentName).add("status", (Object)this.status).add("cause", this.cause).toString();
    }
}

