/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Keyword;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;

public class MessageMetadataView
implements MessageView {
    private final MessageId id;
    private final BlobId blobId;
    private final String threadId;
    private final ImmutableSet<MailboxId> mailboxIds;
    private final Number size;
    private final Keywords keywords;

    public static Builder messageMetadataBuilder() {
        return new Builder();
    }

    @VisibleForTesting
    MessageMetadataView(MessageId id, BlobId blobId, String threadId, ImmutableSet<MailboxId> mailboxIds, Number size, Keywords keywords) {
        this.id = id;
        this.blobId = blobId;
        this.threadId = threadId;
        this.mailboxIds = mailboxIds;
        this.size = size;
        this.keywords = keywords;
    }

    @Override
    public MessageId getId() {
        return this.id;
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public ImmutableSet<MailboxId> getMailboxIds() {
        return this.mailboxIds;
    }

    public boolean isIsUnread() {
        return !this.keywords.contains(Keyword.SEEN);
    }

    public boolean isIsFlagged() {
        return this.keywords.contains(Keyword.FLAGGED);
    }

    public boolean isIsAnswered() {
        return this.keywords.contains(Keyword.ANSWERED);
    }

    public boolean isIsDraft() {
        return this.keywords.contains(Keyword.DRAFT);
    }

    public boolean isIsForwarded() {
        return this.keywords.contains(Keyword.FORWARDED) || this.keywords.contains(Keyword.of("$forwarded"));
    }

    public Number getSize() {
        return this.size;
    }

    public ImmutableMap<String, Boolean> getKeywords() {
        return this.keywords.asMap();
    }

    public static class Builder<S extends Builder<S>> {
        protected MessageId id;
        protected BlobId blobId;
        protected String threadId;
        protected ImmutableSet<MailboxId> mailboxIds;
        protected Number size;
        protected Optional<Keywords> keywords = Optional.empty();

        public S id(MessageId id) {
            this.id = id;
            return (S)this;
        }

        public S blobId(BlobId blobId) {
            this.blobId = blobId;
            return (S)this;
        }

        public S threadId(String threadId) {
            this.threadId = threadId;
            return (S)this;
        }

        @JsonIgnore
        public S mailboxId(MailboxId mailboxId) {
            return this.fluentMailboxIds(mailboxId);
        }

        @JsonIgnore
        public S fluentMailboxIds(MailboxId ... mailboxIds) {
            return this.mailboxIds(Arrays.asList(mailboxIds));
        }

        public S mailboxIds(Collection<MailboxId> mailboxIds) {
            this.mailboxIds = ImmutableSet.copyOf(mailboxIds);
            return (S)this;
        }

        public S keywords(Keywords keywords) {
            this.keywords = Optional.ofNullable(keywords);
            return (S)this;
        }

        public S size(long size) {
            this.size = Number.BOUND_SANITIZING_FACTORY.from(size);
            return (S)this;
        }

        public MessageMetadataView build() {
            this.checkState();
            return new MessageMetadataView(this.id, this.blobId, this.threadId, this.mailboxIds, this.size, this.keywords.orElse(Keywords.DEFAULT_VALUE));
        }

        protected void checkState() {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"'id' is mandatory");
            Preconditions.checkState((this.blobId != null ? 1 : 0) != 0, (Object)"'blobId' is mandatory");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.threadId) ? 1 : 0) != 0, (Object)"'threadId' is mandatory");
            Preconditions.checkState((this.mailboxIds != null ? 1 : 0) != 0, (Object)"'mailboxIds' is mandatory");
            Preconditions.checkState((this.size != null ? 1 : 0) != 0, (Object)"'size' is mandatory");
        }
    }
}

