/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.transport.mailets.utils.MimeMessageModifier;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class AddSubjectPrefix
extends GenericMailet {
    private String subjectPrefix;

    public void init() throws MessagingException {
        this.subjectPrefix = this.getInitParameter("subjectPrefix");
        if (Strings.isNullOrEmpty((String)this.subjectPrefix)) {
            throw new MessagingException("Please configure a valid subjectPrefix");
        }
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        new MimeMessageModifier(message).replaceSubject(new MimeMessageUtils(message).subjectWithPrefix(this.subjectPrefix));
    }

    public String getMailetInfo() {
        return "AddSubjectPrefix Mailet";
    }
}

