/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.opensearch.search;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class ScrolledSearch {
    private static final Time TIMEOUT = (Time)new Time.Builder().time("1m").build();
    private final ReactorOpenSearchClient client;
    private final SearchRequest searchRequest;

    public ScrolledSearch(ReactorOpenSearchClient client, SearchRequest searchRequest) {
        this.client = client;
        this.searchRequest = searchRequest;
    }

    public Flux<Hit<ObjectNode>> searchHits() {
        return this.searchResponses().concatMap(searchResponse -> Flux.fromIterable((Iterable)searchResponse.hits().hits()));
    }

    private Flux<ScrollResponse<ObjectNode>> searchResponses() {
        return Flux.push(sink -> {
            AtomicReference scrollId = new AtomicReference(Optional.empty());
            sink.onRequest(numberOfRequestedElements -> this.next((FluxSink<ScrollResponse<ObjectNode>>)sink, scrollId, numberOfRequestedElements));
            sink.onDispose(() -> this.close(scrollId));
        });
    }

    private void next(FluxSink<ScrollResponse<ObjectNode>> sink, AtomicReference<Optional<String>> scrollId, long numberOfRequestedElements) {
        if (numberOfRequestedElements <= 0L) {
            return;
        }
        Consumer<ScrollResponse> onResponse = searchResponse -> {
            scrollId.set(Optional.of(searchResponse.scrollId()));
            sink.next(searchResponse);
            if (searchResponse.hits().hits().isEmpty()) {
                sink.complete();
            } else {
                this.next(sink, scrollId, numberOfRequestedElements - 1L);
            }
        };
        Consumer<Throwable> onFailure = arg_0 -> sink.error(arg_0);
        this.buildRequest(scrollId.get()).subscribe(onResponse, onFailure);
    }

    private Mono<ScrollResponse<ObjectNode>> buildRequest(Optional<String> scrollId) {
        return scrollId.map(Throwing.function(id -> this.client.scroll(new ScrollRequest.Builder().scrollId((String)scrollId.get()).scroll(TIMEOUT).build())).sneakyThrow()).orElseGet(() -> {
            try {
                return this.client.search(this.searchRequest).map(response -> ((ScrollResponse.Builder)((ScrollResponse.Builder)((ScrollResponse.Builder)((ScrollResponse.Builder)((ScrollResponse.Builder)new ScrollResponse.Builder().scrollId(response.scrollId())).hits(response.hits())).took(response.took())).timedOut(response.timedOut())).shards(response.shards())).build());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void close(AtomicReference<Optional<String>> scrollId) {
        scrollId.get().map(id -> new ClearScrollRequest.Builder().scrollId(id, new String[0]).build()).ifPresent(Throwing.consumer(clearScrollRequest -> this.client.clearScroll((ClearScrollRequest)clearScrollRequest).subscribe()).sneakyThrow());
    }
}

