/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.util.Loggers;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MultiplexingSchemaChangeListener
implements SchemaChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(MultiplexingSchemaChangeListener.class);
    private final List<SchemaChangeListener> listeners = new CopyOnWriteArrayList<SchemaChangeListener>();

    public MultiplexingSchemaChangeListener() {
    }

    public MultiplexingSchemaChangeListener(SchemaChangeListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public MultiplexingSchemaChangeListener(Collection<SchemaChangeListener> listeners) {
        this.addListeners(listeners);
    }

    private void addListeners(Collection<SchemaChangeListener> source) {
        for (SchemaChangeListener listener : source) {
            this.addListener(listener);
        }
    }

    private void addListener(SchemaChangeListener toAdd) {
        Objects.requireNonNull(toAdd, "listener cannot be null");
        if (toAdd instanceof MultiplexingSchemaChangeListener) {
            this.addListeners(((MultiplexingSchemaChangeListener)toAdd).listeners);
        } else {
            this.listeners.add(toAdd);
        }
    }

    public void register(@NonNull SchemaChangeListener listener) {
        this.addListener(listener);
    }

    @Override
    public void onKeyspaceCreated(@NonNull KeyspaceMetadata keyspace) {
        this.invokeListeners(listener -> listener.onKeyspaceCreated(keyspace), "onKeyspaceCreated");
    }

    @Override
    public void onKeyspaceDropped(@NonNull KeyspaceMetadata keyspace) {
        this.invokeListeners(listener -> listener.onKeyspaceDropped(keyspace), "onKeyspaceDropped");
    }

    @Override
    public void onKeyspaceUpdated(@NonNull KeyspaceMetadata current, @NonNull KeyspaceMetadata previous) {
        this.invokeListeners(listener -> listener.onKeyspaceUpdated(current, previous), "onKeyspaceUpdated");
    }

    @Override
    public void onTableCreated(@NonNull TableMetadata table) {
        this.invokeListeners(listener -> listener.onTableCreated(table), "onTableCreated");
    }

    @Override
    public void onTableDropped(@NonNull TableMetadata table) {
        this.invokeListeners(listener -> listener.onTableDropped(table), "onTableDropped");
    }

    @Override
    public void onTableUpdated(@NonNull TableMetadata current, @NonNull TableMetadata previous) {
        this.invokeListeners(listener -> listener.onTableUpdated(current, previous), "onTableUpdated");
    }

    @Override
    public void onUserDefinedTypeCreated(@NonNull UserDefinedType type) {
        this.invokeListeners(listener -> listener.onUserDefinedTypeCreated(type), "onUserDefinedTypeCreated");
    }

    @Override
    public void onUserDefinedTypeDropped(@NonNull UserDefinedType type) {
        this.invokeListeners(listener -> listener.onUserDefinedTypeDropped(type), "onUserDefinedTypeDropped");
    }

    @Override
    public void onUserDefinedTypeUpdated(@NonNull UserDefinedType current, @NonNull UserDefinedType previous) {
        this.invokeListeners(listener -> listener.onUserDefinedTypeUpdated(current, previous), "onUserDefinedTypeUpdated");
    }

    @Override
    public void onFunctionCreated(@NonNull FunctionMetadata function) {
        this.invokeListeners(listener -> listener.onFunctionCreated(function), "onFunctionCreated");
    }

    @Override
    public void onFunctionDropped(@NonNull FunctionMetadata function) {
        this.invokeListeners(listener -> listener.onFunctionDropped(function), "onFunctionDropped");
    }

    @Override
    public void onFunctionUpdated(@NonNull FunctionMetadata current, @NonNull FunctionMetadata previous) {
        this.invokeListeners(listener -> listener.onFunctionUpdated(current, previous), "onFunctionUpdated");
    }

    @Override
    public void onAggregateCreated(@NonNull AggregateMetadata aggregate) {
        this.invokeListeners(listener -> listener.onAggregateCreated(aggregate), "onAggregateCreated");
    }

    @Override
    public void onAggregateDropped(@NonNull AggregateMetadata aggregate) {
        this.invokeListeners(listener -> listener.onAggregateDropped(aggregate), "onAggregateDropped");
    }

    @Override
    public void onAggregateUpdated(@NonNull AggregateMetadata current, @NonNull AggregateMetadata previous) {
        this.invokeListeners(listener -> listener.onAggregateUpdated(current, previous), "onAggregateUpdated");
    }

    @Override
    public void onViewCreated(@NonNull ViewMetadata view) {
        this.invokeListeners(listener -> listener.onViewCreated(view), "onViewCreated");
    }

    @Override
    public void onViewDropped(@NonNull ViewMetadata view) {
        this.invokeListeners(listener -> listener.onViewDropped(view), "onViewDropped");
    }

    @Override
    public void onViewUpdated(@NonNull ViewMetadata current, @NonNull ViewMetadata previous) {
        this.invokeListeners(listener -> listener.onViewUpdated(current, previous), "onViewUpdated");
    }

    @Override
    public void onSessionReady(@NonNull Session session) {
        this.invokeListeners(listener -> listener.onSessionReady(session), "onSessionReady");
    }

    @Override
    public void close() throws Exception {
        for (SchemaChangeListener listener : this.listeners) {
            try {
                listener.close();
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "Unexpected error while closing schema change listener {}.", listener, e);
            }
        }
    }

    private void invokeListeners(@NonNull Consumer<SchemaChangeListener> action, String event) {
        for (SchemaChangeListener listener : this.listeners) {
            try {
                action.accept(listener);
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "Unexpected error while notifying schema change listener {} of an {} event.", listener, event, e);
            }
        }
    }
}

