/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class TrackHits
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TrackHits> _DESERIALIZER = JsonpDeserializer.lazy(TrackHits::buildTrackHitsDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private TrackHits(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Count: {
                return String.valueOf(this.count());
            }
            case Enabled: {
                return String.valueOf(this.enabled());
            }
        }
        throw new IllegalStateException("Unknown kind " + this._kind);
    }

    private TrackHits(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TrackHits of(Function<Builder, ObjectBuilder<TrackHits>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCount() {
        return this._kind == Kind.Count;
    }

    public Integer count() {
        return (Integer)TaggedUnionUtils.get(this, Kind.Count);
    }

    public boolean isEnabled() {
        return this._kind == Kind.Enabled;
    }

    public Boolean enabled() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Enabled);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Count: {
                    generator.write(((Integer)this._value).intValue());
                    break;
                }
                case Enabled: {
                    generator.write(((Boolean)this._value).booleanValue());
                }
            }
        }
    }

    private static JsonpDeserializer<TrackHits> buildTrackHitsDeserializer() {
        return new UnionDeserializer.Builder<TrackHits, Kind, Object>(TrackHits::new, false).addMember(Kind.Count, JsonpDeserializer.integerDeserializer()).addMember(Kind.Enabled, JsonpDeserializer.booleanDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TrackHits> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<TrackHits> count(Integer v) {
            this._kind = Kind.Count;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TrackHits> enabled(Boolean v) {
            this._kind = Kind.Enabled;
            this._value = v;
            return this;
        }

        @Override
        public TrackHits build() {
            this._checkSingleUse();
            return new TrackHits(this);
        }
    }

    public static enum Kind {
        Count,
        Enabled;

    }
}

