/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.github.fge.lambdas.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.futurerelease.FutureReleaseMailParameterHook;
import org.apache.james.util.MDCBuilder;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailHandler
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMailHandler.class);
    private final MailQueueFactory<?> queueFactory;
    private MailQueue queue;

    @Inject
    public SendMailHandler(MailQueueFactory<?> queueFactory) {
        this.queueFactory = queueFactory;
    }

    public void init(Configuration config) {
        this.queue = this.queueFactory.createQueue(MailQueueFactory.SPOOL);
    }

    public void destroy() {
        try {
            this.queue.close();
        }
        catch (IOException e) {
            LOGGER.debug("error close queue", (Throwable)e);
        }
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        LOGGER.debug("sending mail");
        try (Closeable closeable = MDCBuilder.ofValue((String)"messageId", (String)mail.getMessage().getMessageID()).build();){
            Optional delays = session.getAttachment(FutureReleaseMailParameterHook.FUTURERELEASE_HOLDFOR, ProtocolSession.State.Transaction);
            delays.ifPresentOrElse(Throwing.consumer(holdFor -> {
                this.queue.enQueue(mail, holdFor.value());
                LOGGER.info("Successfully spooled mail {} with messageId {} from {} on {} for {} with delay {}", new Object[]{mail.getName(), mail.getMessage().getMessageID(), mail.getMaybeSender().asString(), session.getRemoteAddress().getAddress(), mail.getRecipients(), holdFor.value()});
            }), (Runnable)Throwing.runnable(() -> {
                this.queue.enQueue(mail);
                LOGGER.info("Successfully spooled mail {} with messageId {} from {} on {} for {}", new Object[]{mail.getName(), mail.getMessage().getMessageID(), mail.getMaybeSender().asString(), session.getRemoteAddress().getAddress(), mail.getRecipients()});
            }));
        }
        catch (Exception me) {
            LOGGER.error("Unknown error occurred while processing DATA.", (Throwable)me);
            return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpDescription(DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message.").build();
        }
        return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received").build();
    }
}

