/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry;

import org.apache.james.util.retry.api.ExceptionRetryingProxy;
import org.apache.james.util.retry.api.RetryHandler;
import org.apache.james.util.retry.api.RetrySchedule;

public abstract class ExceptionRetryHandler
implements RetryHandler {
    private Class<?>[] exceptionClasses = null;
    private ExceptionRetryingProxy proxy = null;
    private RetrySchedule schedule;
    private int maxRetries = 0;

    private ExceptionRetryHandler() {
    }

    public ExceptionRetryHandler(Class<?>[] exceptionClasses, ExceptionRetryingProxy proxy, RetrySchedule schedule, int maxRetries) {
        this();
        this.exceptionClasses = exceptionClasses;
        this.proxy = proxy;
        this.schedule = schedule;
        this.maxRetries = maxRetries;
    }

    @Override
    public Object perform() throws Exception {
        boolean success = false;
        Object result = null;
        int retryCount = 0;
        while (!success) {
            try {
                if (retryCount > 0) {
                    this.proxy.resetDelegate();
                }
                result = this.operation();
                success = true;
            }
            catch (Exception ex) {
                if (retryCount >= this.maxRetries || !this.isRetryable(ex)) {
                    throw ex;
                }
                this.postFailure(ex, retryCount);
                try {
                    Thread.sleep(this.getRetryInterval(retryCount));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                retryCount = this.maxRetries < 0 ? this.maxRetries : retryCount + 1;
            }
        }
        return result;
    }

    private boolean isRetryable(Throwable ex) {
        boolean isRetryable = false;
        for (int i = 0; !isRetryable && i < this.exceptionClasses.length; ++i) {
            isRetryable = this.exceptionClasses[i].isInstance(ex);
        }
        return isRetryable;
    }

    @Override
    public void postFailure(Exception ex, int retryCount) {
    }

    @Override
    public abstract Object operation() throws Exception;

    public long getRetryInterval(int retryCount) {
        return this.schedule.getInterval(retryCount);
    }
}

