/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.jsieve.util.HaltTraversalException;
import org.apache.jsieve.util.SieveHandler;

public class ToSieveHandlerFactory {
    public SieveHandler build(Writer writer) {
        return new ToSieveHandler(writer);
    }

    private static final class ToSieveHandler
    extends SieveHandler.Base {
        private final Writer writer;
        private boolean commaRequiredBeforeNextTest;
        private boolean firstTestInList;
        private boolean commandUsedBlock;
        private boolean commandAfterEndCommand;

        public ToSieveHandler(Writer writer) {
            this.writer = writer;
            this.commaRequiredBeforeNextTest = false;
            this.firstTestInList = false;
            this.commandUsedBlock = false;
            this.commandAfterEndCommand = false;
        }

        @Override
        public SieveHandler endBlock() throws HaltTraversalException {
            this.commandUsedBlock = true;
            return this.append('}');
        }

        @Override
        public SieveHandler startBlock() throws HaltTraversalException {
            this.space();
            return this.append('{');
        }

        @Override
        public SieveHandler startCommand(String commandName) throws HaltTraversalException {
            this.commaRequiredBeforeNextTest = false;
            if (this.commandAfterEndCommand) {
                this.space();
                this.commandAfterEndCommand = false;
            }
            return this.append(commandName);
        }

        @Override
        public SieveHandler endCommand(String commandName) throws HaltTraversalException {
            if (!this.commandUsedBlock) {
                this.append(';');
            }
            this.commandAfterEndCommand = true;
            this.commandUsedBlock = false;
            return this;
        }

        @Override
        public SieveHandler argument(String tag) throws HaltTraversalException {
            this.space();
            this.append(':');
            return this.append(tag);
        }

        private void space() throws HaltTraversalException {
            this.append(' ');
        }

        @Override
        public SieveHandler argument(int number) throws HaltTraversalException {
            this.space();
            return this.append(Integer.toString(number));
        }

        @Override
        public SieveHandler startStringListArgument() throws HaltTraversalException {
            this.space();
            return this.append('[');
        }

        @Override
        public SieveHandler endStringListArgument() throws HaltTraversalException {
            return this.append(']');
        }

        @Override
        public SieveHandler listMember(String string) throws HaltTraversalException {
            this.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                char next = string.charAt(i);
                if (next == '\"' || next == '\\' || next == '\r' || next == '\f') {
                    this.append('\\');
                }
                this.append(next);
            }
            return this.append('\"');
        }

        @Override
        public SieveHandler startTestList() throws HaltTraversalException {
            this.firstTestInList = true;
            this.commaRequiredBeforeNextTest = false;
            return this.append('(');
        }

        @Override
        public SieveHandler endTestList() throws HaltTraversalException {
            this.commaRequiredBeforeNextTest = false;
            return this.append(')');
        }

        @Override
        public SieveHandler startTest(String testName) throws HaltTraversalException {
            if (this.commaRequiredBeforeNextTest) {
                this.append(",");
            }
            if (!this.firstTestInList) {
                this.space();
            }
            this.commaRequiredBeforeNextTest = true;
            this.firstTestInList = false;
            return this.append(testName);
        }

        private SieveHandler append(CharSequence characterSequence) throws HaltTraversalException {
            try {
                this.writer.append(characterSequence);
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }

        private SieveHandler append(char character) throws HaltTraversalException {
            try {
                this.writer.append(character);
                return this;
            }
            catch (IOException e) {
                throw new HaltTraversalException(e);
            }
        }
    }
}

